/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.sign.in.local.service.internal;

import com.biz.crm.sfa.business.sign.in.local.entity.SignInGroupScopeEntity;
import com.biz.crm.sfa.business.sign.in.local.repository.SignInGroupScopeRepository;
import com.biz.crm.sfa.business.sign.in.local.service.SignInGroupScopeService;
import com.biz.crm.sfa.business.sign.in.sdk.dto.SignInGroupDto;
import com.biz.crm.sfa.business.sign.in.sdk.dto.SignInGroupScopeDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="signInGroupScopeService")
public class SignInGroupScopeServiceImpl
implements SignInGroupScopeService {
    private static final Logger log = LoggerFactory.getLogger(SignInGroupScopeServiceImpl.class);
    @Autowired
    private SignInGroupScopeRepository signInGroupScopeRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void update(SignInGroupDto dto) {
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u7b7e\u5230\u7ec4ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.signInGroupScopeRepository.deleteByGroupId(dto.getId());
        if (CollectionUtils.isEmpty((Collection)dto.getScopeList())) {
            return;
        }
        this.updateValidation(dto);
        List entities = dto.getScopeList().stream().map(scopeDto -> {
            SignInGroupScopeEntity entity = (SignInGroupScopeEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(scopeDto, SignInGroupScopeEntity.class, HashSet.class, ArrayList.class, new String[0])));
            entity.setGroupId(dto.getId());
            return entity;
        }).collect(Collectors.toList());
        this.signInGroupScopeRepository.saveBatch(entities);
    }

    private void updateValidation(SignInGroupDto dto) {
        for (SignInGroupScopeDto scopeDto : dto.getScopeList()) {
            Validate.notBlank((CharSequence)scopeDto.getScopeCode(), (String)"\u7f3a\u5931\u8303\u56f4\u7f16\u7801", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)scopeDto.getScopeType(), (String)"\u7f3a\u5931\u8303\u56f4\u7c7b\u578b", (Object[])new Object[0]);
        }
    }
}

