/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.sign.in.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.sfa.business.sign.in.local.entity.SignInGroupEntity;
import com.biz.crm.sfa.business.sign.in.local.repository.SignInGroupRepository;
import com.biz.crm.sfa.business.sign.in.local.service.SignInGroupDateService;
import com.biz.crm.sfa.business.sign.in.local.service.SignInGroupPlaceService;
import com.biz.crm.sfa.business.sign.in.local.service.SignInGroupScopeService;
import com.biz.crm.sfa.business.sign.in.local.service.SignInGroupService;
import com.biz.crm.sfa.business.sign.in.local.service.SignInGroupTypeService;
import com.biz.crm.sfa.business.sign.in.sdk.dto.SignInGroupDto;
import com.biz.crm.sfa.business.sign.in.sdk.dto.SignInGroupPageDto;
import com.biz.crm.sfa.business.sign.in.sdk.enums.SignInElectronFenceType;
import com.biz.crm.sfa.business.sign.in.sdk.event.SignInGroupEventListener;
import com.biz.crm.sfa.business.sign.in.sdk.vo.SignInGroupVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="signInGroupService")
public class SignInGroupServiceImpl
implements SignInGroupService {
    private static final Logger log = LoggerFactory.getLogger(SignInGroupServiceImpl.class);
    @Autowired
    private SignInGroupRepository signInGroupRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private SignInGroupTypeService signInGroupTypeService;
    @Autowired
    private SignInGroupDateService signInGroupDateService;
    @Autowired
    private SignInGroupPlaceService signInGroupPlaceService;
    @Autowired
    private SignInGroupScopeService signInGroupScopeService;
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private List<SignInGroupEventListener> listeners;

    @Override
    @Transactional
    public SignInGroupEntity create(SignInGroupDto dto) {
        this.createValidation(dto);
        SignInGroupEntity entity = (SignInGroupEntity)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, SignInGroupEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setGroupCode((String)this.generateCodeService.generateCode("SIG", 1).get(0));
        this.signInGroupRepository.save((Object)entity);
        dto.setId(entity.getId());
        this.bindRelationData(dto);
        if (!CollectionUtils.isEmpty(this.listeners)) {
            SignInGroupVo vo = (SignInGroupVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, SignInGroupVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.listeners.forEach(listener -> listener.onCreate(vo));
        }
        return entity;
    }

    @Override
    @Transactional
    public SignInGroupEntity update(SignInGroupDto dto) {
        this.updateValidation(dto);
        List<SignInGroupEntity> entities = this.signInGroupRepository.findByIds(Lists.newArrayList((Object[])new String[]{dto.getId()}));
        Validate.isTrue((!CollectionUtils.isEmpty(entities) ? 1 : 0) != 0, (String)"\u7b7e\u5230\u7ec4\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        SignInGroupEntity updateEntity = (SignInGroupEntity)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, SignInGroupEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.signInGroupRepository.updateById((Object)updateEntity);
        this.bindRelationData(dto);
        if (!CollectionUtils.isEmpty(this.listeners)) {
            SignInGroupVo oldVo = (SignInGroupVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entities.get(0), SignInGroupVo.class, HashSet.class, ArrayList.class, new String[0]);
            SignInGroupVo newVo = (SignInGroupVo)this.nebulaToolkitService.copyObjectByBlankList((Object)updateEntity, SignInGroupVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.listeners.forEach(listener -> listener.onUpdate(oldVo, newVo));
        }
        return updateEntity;
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List entities = this.signInGroupRepository.listByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u5220\u9664\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.signInGroupRepository.updateDelFlagByIds(ids);
        if (!CollectionUtils.isEmpty(this.listeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entities, SignInGroupEntity.class, SignInGroupVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.listeners.forEach(listener -> listener.onDelete(voList));
        }
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List entities = this.signInGroupRepository.listByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u542f\u7528\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.signInGroupRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
        if (!CollectionUtils.isEmpty(this.listeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entities, SignInGroupEntity.class, SignInGroupVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.listeners.forEach(listener -> listener.onEnable(voList));
        }
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List entities = this.signInGroupRepository.listByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u7981\u7528\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.signInGroupRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
        if (!CollectionUtils.isEmpty(this.listeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entities, SignInGroupEntity.class, SignInGroupVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.listeners.forEach(listener -> listener.onDisable(voList));
        }
    }

    @Override
    public Page<SignInGroupEntity> findByConditions(Pageable pageable, SignInGroupPageDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (SignInGroupPageDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new SignInGroupPageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.signInGroupRepository.findByConditions(pageable, dto);
    }

    private void bindRelationData(SignInGroupDto dto) {
        this.signInGroupTypeService.update(dto);
        this.signInGroupDateService.update(dto);
        this.signInGroupPlaceService.update(dto);
        this.signInGroupScopeService.update(dto);
    }

    private void createValidation(SignInGroupDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setId(null);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getGroupName(), (String)"\u7f3a\u5931\u7b7e\u5230\u7ec4\u540d\u79f0", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getTimeType(), (String)"\u7f3a\u5931\u6709\u6548\u65f6\u95f4\u7c7b\u578b", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)dto.getScopeList()) ? 1 : 0) != 0, (String)"\u7f3a\u5931\u9002\u7528\u8303\u56f4", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)dto.getTypeList()) ? 1 : 0) != 0, (String)"\u7f3a\u5931\u7b7e\u5230\u7c7b\u578b", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty((Collection)dto.getPlaceList())) {
            Validate.notBlank((CharSequence)dto.getElectronFenceType(), (String)"\u7f3a\u5931\u6253\u5361\u8303\u56f4\u7c7b\u578b", (Object[])new Object[0]);
        } else {
            dto.setElectronFenceType(SignInElectronFenceType.NONE.getDictCode());
        }
    }

    private void updateValidation(SignInGroupDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getGroupName(), (String)"\u7f3a\u5931\u7b7e\u5230\u7ec4\u540d\u79f0", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getTimeType(), (String)"\u7f3a\u5931\u6709\u6548\u65f6\u95f4\u7c7b\u578b", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)dto.getScopeList()) ? 1 : 0) != 0, (String)"\u7f3a\u5931\u9002\u7528\u8303\u56f4", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)dto.getTypeList()) ? 1 : 0) != 0, (String)"\u7f3a\u5931\u7b7e\u5230\u7c7b\u578b", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty((Collection)dto.getPlaceList())) {
            Validate.notBlank((CharSequence)dto.getElectronFenceType(), (String)"\u7f3a\u5931\u6253\u5361\u8303\u56f4\u7c7b\u578b", (Object[])new Object[0]);
        } else {
            dto.setElectronFenceType(SignInElectronFenceType.NONE.getDictCode());
        }
    }
}

