/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.sign.in.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.vo.UuidVo;
import com.biz.crm.mdm.business.org.sdk.service.OrgPositionVoService;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgPositionVo;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserPositionVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserPositionVo;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.sfa.business.sign.in.local.entity.SignInGroupEntity;
import com.biz.crm.sfa.business.sign.in.local.entity.SignInGroupTypeEntity;
import com.biz.crm.sfa.business.sign.in.local.entity.SignInTypeEntity;
import com.biz.crm.sfa.business.sign.in.local.repository.SignInGroupRepository;
import com.biz.crm.sfa.business.sign.in.local.repository.SignInGroupTypeRepository;
import com.biz.crm.sfa.business.sign.in.local.repository.SignInTypeRepository;
import com.biz.crm.sfa.business.sign.in.sdk.constant.SignInConstant;
import com.biz.crm.sfa.business.sign.in.sdk.dto.SignInGroupPageDto;
import com.biz.crm.sfa.business.sign.in.sdk.dto.SignInGroupUserPageDto;
import com.biz.crm.sfa.business.sign.in.sdk.enums.SignInScopeType;
import com.biz.crm.sfa.business.sign.in.sdk.service.SignInGroupVoService;
import com.biz.crm.sfa.business.sign.in.sdk.vo.SignInGroupScopeVo;
import com.biz.crm.sfa.business.sign.in.sdk.vo.SignInGroupTypeVo;
import com.biz.crm.sfa.business.sign.in.sdk.vo.SignInGroupVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SignInGroupVoServiceImpl
implements SignInGroupVoService {
    private static final Logger log = LoggerFactory.getLogger(SignInGroupVoServiceImpl.class);
    @Autowired
    private SignInGroupRepository signInGroupRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private OrgVoService orgVoService;
    @Autowired
    private UserFeignVoService userFeignVoService;
    @Autowired
    private SignInTypeRepository signInTypeRepository;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private SignInGroupTypeRepository signInGroupTypeRepository;
    @Autowired
    private UserPositionVoService userPositionVoService;
    @Autowired
    private OrgPositionVoService orgPositionVoService;

    public SignInGroupVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        List<SignInGroupEntity> entities = this.signInGroupRepository.findByIds(Lists.newArrayList((Object[])new String[]{id}));
        if (CollectionUtils.isEmpty(entities)) {
            return null;
        }
        SignInGroupVo signInGroupVo = (SignInGroupVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entities.get(0), SignInGroupVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.perfectScopeInfo(Lists.newArrayList((Object[])new SignInGroupVo[]{signInGroupVo}));
        this.perfectTypeInfo(Lists.newArrayList((Object[])new SignInGroupVo[]{signInGroupVo}));
        return signInGroupVo;
    }

    public Page<SignInGroupVo> findBySignInGroupUserPageDto(Pageable pageable, SignInGroupUserPageDto dto) {
        List orgPositionList;
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        SignInGroupPageDto groupPageDto = new SignInGroupPageDto();
        groupPageDto.setTenantCode(TenantUtils.getTenantCode());
        groupPageDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        groupPageDto.setSignInDate(LocalDateTime.now().format(SignInConstant.YYYY_MM_DD));
        LoginUserDetails loginDetails = (LoginUserDetails)this.loginUserService.getLoginDetails(LoginUserDetails.class);
        groupPageDto.setOrgCodes((Set)Sets.newHashSet((Object[])new String[]{loginDetails.getOrgCode()}));
        groupPageDto.setUserName(loginDetails.getAccount());
        List userPositionList = this.userPositionVoService.findByUserName(TenantUtils.getTenantCode(), groupPageDto.getUserName());
        if (!CollectionUtils.isEmpty((Collection)userPositionList) && !CollectionUtils.isEmpty((Collection)(orgPositionList = this.orgPositionVoService.findByPositionCodes(userPositionList.stream().map(UserPositionVo::getPositionCode).collect(Collectors.toList()))))) {
            groupPageDto.getOrgCodes().addAll(orgPositionList.stream().map(OrgPositionVo::getOrgCode).collect(Collectors.toList()));
        }
        Page<SignInGroupEntity> entityPage = this.signInGroupRepository.findByConditions(pageable, groupPageDto);
        Page pageResult = new Page(entityPage.getCurrent(), entityPage.getSize(), entityPage.getTotal());
        if (CollectionUtils.isEmpty((Collection)entityPage.getRecords())) {
            return pageResult;
        }
        List list = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)entityPage.getRecords(), SignInGroupEntity.class, SignInGroupVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.perfectTypeInfo(list);
        pageResult.setRecords(list);
        return pageResult;
    }

    private void perfectTypeInfo(List<SignInGroupVo> groupList) {
        if (CollectionUtils.isEmpty(groupList)) {
            return;
        }
        List<String> groupIds = groupList.stream().map(UuidVo::getId).collect(Collectors.toList());
        List<SignInGroupTypeEntity> groupTypeEntities = this.signInGroupTypeRepository.findByGroupIds(groupIds);
        if (CollectionUtils.isEmpty(groupTypeEntities)) {
            return;
        }
        Set typeIds = groupTypeEntities.stream().map(SignInGroupTypeEntity::getTypeId).collect(Collectors.toSet());
        List typeEntities = this.signInTypeRepository.listByIds(typeIds);
        if (CollectionUtils.isEmpty((Collection)typeEntities)) {
            return;
        }
        Map<String, SignInTypeEntity> typeMap = typeEntities.stream().collect(Collectors.toMap(UuidEntity::getId, t -> t, (a, b) -> a));
        Map groupTypeMap = groupTypeEntities.stream().collect(Collectors.groupingBy(SignInGroupTypeEntity::getGroupId, Collectors.mapping(SignInGroupTypeEntity::getTypeId, Collectors.toList())));
        groupList.forEach(signInGroupVo -> {
            List groupTypeIds = (List)groupTypeMap.get(signInGroupVo.getId());
            if (CollectionUtils.isEmpty((Collection)groupTypeIds)) {
                return;
            }
            List typeList = groupTypeIds.stream().map(typeId -> {
                SignInTypeEntity entity = (SignInTypeEntity)((Object)((Object)((Object)typeMap.get(typeId))));
                if (Objects.isNull((Object)entity)) {
                    return null;
                }
                SignInGroupTypeVo groupTypeVo = new SignInGroupTypeVo();
                groupTypeVo.setTypeId(typeId);
                groupTypeVo.setTypeName(entity.getTypeName());
                return groupTypeVo;
            }).collect(Collectors.toList());
            signInGroupVo.setTypeList(typeList);
        });
    }

    private void perfectScopeInfo(List<SignInGroupVo> groupList) {
        if (CollectionUtils.isEmpty(groupList)) {
            return;
        }
        List<SignInGroupScopeVo> scopeList = groupList.stream().filter(vo -> !CollectionUtils.isEmpty((Collection)vo.getScopeList())).flatMap(vo -> vo.getScopeList().stream()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(scopeList)) {
            return;
        }
        HashSet orgCodes = Sets.newHashSet();
        HashSet userNames = Sets.newHashSet();
        scopeList.forEach(scopeVo -> {
            if (SignInScopeType.ORG.getDictCode().equals(scopeVo.getScopeType())) {
                orgCodes.add(scopeVo.getScopeCode());
            }
            if (SignInScopeType.USER.getDictCode().equals(scopeVo.getScopeType())) {
                userNames.add(scopeVo.getScopeCode());
            }
        });
        Map<String, OrgVo> orgMap = this.buildOrgMap(orgCodes);
        Map<String, UserVo> userMap = this.buildUserMap(userNames);
        for (SignInGroupScopeVo scopeVo2 : scopeList) {
            if (SignInScopeType.ORG.getDictCode().equals(scopeVo2.getScopeType())) {
                OrgVo orgVo = orgMap.getOrDefault(scopeVo2.getScopeCode(), new OrgVo());
                scopeVo2.setScopeName(orgVo.getOrgName());
            }
            if (!SignInScopeType.USER.getDictCode().equals(scopeVo2.getScopeType())) continue;
            UserVo userVo = userMap.getOrDefault(scopeVo2.getScopeCode(), new UserVo());
            scopeVo2.setScopeName(userVo.getFullName());
        }
    }

    private Map<String, UserVo> buildUserMap(Set<String> userNames) {
        List userList;
        Map<Object, Object> userMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(userNames) && !CollectionUtils.isEmpty((Collection)(userList = this.userFeignVoService.findByUserNames((List)Lists.newArrayList(userNames))))) {
            userMap = userList.stream().collect(Collectors.toMap(UserVo::getUserName, t -> t, (a, b) -> b));
        }
        return userMap;
    }

    private Map<String, OrgVo> buildOrgMap(Set<String> orgCodes) {
        List orgList;
        Map<Object, Object> orgMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(orgCodes) && !CollectionUtils.isEmpty((Collection)(orgList = this.orgVoService.findByOrgCodes((List)Lists.newArrayList(orgCodes))))) {
            orgMap = orgList.stream().collect(Collectors.toMap(OrgVo::getOrgCode, t -> t, (a, b) -> b));
        }
        return orgMap;
    }
}

