/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.sign.in.local.service.internal;

import com.biz.crm.sfa.business.sign.in.local.entity.SignInRecordPictureEntity;
import com.biz.crm.sfa.business.sign.in.local.repository.SignInRecordPictureRepository;
import com.biz.crm.sfa.business.sign.in.local.service.SignInRecordPictureService;
import com.biz.crm.sfa.business.sign.in.sdk.dto.SignInRecordDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="signInRecordPictureService")
public class SignInRecordPictureServiceImpl
implements SignInRecordPictureService {
    private static final Logger log = LoggerFactory.getLogger(SignInRecordPictureServiceImpl.class);
    @Autowired
    private SignInRecordPictureRepository signInRecordPictureRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void update(SignInRecordDto dto) {
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u7b7e\u5230\u8bb0\u5f55ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.signInRecordPictureRepository.deleteByRecordId(dto.getId());
        if (CollectionUtils.isEmpty((Collection)dto.getPictureList())) {
            return;
        }
        this.updateValidation(dto);
        List entities = dto.getPictureList().stream().map(pictureDto -> {
            SignInRecordPictureEntity entity = (SignInRecordPictureEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(pictureDto, SignInRecordPictureEntity.class, HashSet.class, ArrayList.class, new String[0])));
            entity.setRecordId(dto.getId());
            entity.setTenantCode(dto.getTenantCode());
            return entity;
        }).collect(Collectors.toList());
        this.signInRecordPictureRepository.saveBatch(entities);
    }

    private void updateValidation(SignInRecordDto dto) {
        dto.getPictureList().forEach(pictureDto -> {
            Validate.notBlank((CharSequence)pictureDto.getFileName(), (String)"\u7f3a\u5931\u6587\u4ef6\u540d\u79f0", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)pictureDto.getObjectName(), (String)"\u7f3a\u5931\u5bf9\u8c61\u540d", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)pictureDto.getSuffix(), (String)"\u7f3a\u5931\u6587\u4ef6\u540e\u7f00", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)pictureDto.getUrl(), (String)"\u7f3a\u5931\u8bbf\u95ee\u8def\u5f84", (Object[])new Object[0]);
        });
    }
}

