/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.sign.in.local.service.internal;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.utils.DistanceUtil;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.sfa.business.sign.in.local.entity.SignInGroupEntity;
import com.biz.crm.sfa.business.sign.in.local.entity.SignInGroupPlaceEntity;
import com.biz.crm.sfa.business.sign.in.local.entity.SignInRecordEntity;
import com.biz.crm.sfa.business.sign.in.local.entity.SignInTypeEntity;
import com.biz.crm.sfa.business.sign.in.local.model.SignInConditionModel;
import com.biz.crm.sfa.business.sign.in.local.repository.SignInGroupRepository;
import com.biz.crm.sfa.business.sign.in.local.repository.SignInRecordRepository;
import com.biz.crm.sfa.business.sign.in.local.repository.SignInTypeRepository;
import com.biz.crm.sfa.business.sign.in.local.service.SignInRecordPictureService;
import com.biz.crm.sfa.business.sign.in.local.service.SignInRecordService;
import com.biz.crm.sfa.business.sign.in.sdk.constant.SignInConstant;
import com.biz.crm.sfa.business.sign.in.sdk.dto.SignInRecordDto;
import com.biz.crm.sfa.business.sign.in.sdk.enums.SignInElectronFenceType;
import com.biz.crm.sfa.business.sign.in.sdk.enums.SignInPlaceStatus;
import com.biz.crm.sfa.business.sign.in.sdk.enums.SignInStatus;
import com.biz.crm.sfa.business.sign.in.sdk.enums.SignInTimeType;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="signInRecordService")
public class SignInRecordServiceImpl
implements SignInRecordService {
    private static final Logger log = LoggerFactory.getLogger(SignInRecordServiceImpl.class);
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private SignInRecordRepository signInRecordRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private SignInGroupRepository signInGroupRepository;
    @Autowired
    private SignInTypeRepository signInTypeRepository;
    @Autowired
    private SignInRecordPictureService signInRecordPictureService;
    @Autowired
    private UserFeignVoService userFeignVoService;

    @Override
    @Transactional
    public SignInRecordEntity create(SignInRecordDto dto) {
        this.createValidation(dto);
        this.validateSignInGroup(dto);
        SignInRecordEntity entity = (SignInRecordEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, SignInRecordEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setSignInStatus(SignInStatus.OK.getDictCode());
        List userVoList = this.userFeignVoService.findByUserNames(Collections.singletonList(dto.getUserName()));
        if (!CollectionUtils.isEmpty((Collection)userVoList)) {
            Map<String, UserVo> userMap = userVoList.stream().collect(Collectors.toMap(UserVo::getUserName, t -> t, (a, b) -> b));
            UserVo userVo = userMap.get(dto.getUserName());
            entity.setUserRealName(userVo.getFullName());
            entity.setOrgCode(userVo.getOrgCode());
            entity.setOrgName(userVo.getOrgName());
            entity.setPostCode(userVo.getPositionCode());
            entity.setPostName(userVo.getPositionName());
        }
        this.signInRecordRepository.save((Object)entity);
        dto.setId(entity.getId());
        this.signInRecordPictureService.update(dto);
        return entity;
    }

    private void validateSignInGroup(SignInRecordDto dto) {
        List typeEntities;
        if (StringUtils.isBlank((CharSequence)dto.getGroupId())) {
            return;
        }
        List<SignInGroupEntity> groupEntities = this.signInGroupRepository.findByIds(Lists.newArrayList((Object[])new String[]{dto.getGroupId()}));
        Validate.isTrue((!CollectionUtils.isEmpty(groupEntities) ? 1 : 0) != 0, (String)"\u7b7e\u5230\u7ec4\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        SignInGroupEntity groupEntity = groupEntities.get(0);
        if (SignInTimeType.DIY_TIME.getDictCode().equals(groupEntity.getTimeType())) {
            List dateEntities = groupEntity.getDateList().stream().filter(dateEntity -> dateEntity.getStartTime().compareTo(dto.getSignInDate()) <= 0 && dateEntity.getEndTime().compareTo(dto.getSignInDate()) >= 0).collect(Collectors.toList());
            Validate.isTrue((!CollectionUtils.isEmpty(dateEntities) ? 1 : 0) != 0, (String)"\u5f53\u524d\u65e5\u671f\u4e0d\u80fd\u7b7e\u5230!", (Object[])new Object[0]);
        }
        Validate.isTrue((!CollectionUtils.isEmpty(typeEntities = groupEntity.getTypeList().stream().filter(typeEntity -> typeEntity.getTypeId().equals(dto.getSignInTypeId())).collect(Collectors.toList())) ? 1 : 0) != 0, (String)"\u7b7e\u5230\u7c7b\u578b\u4e0e\u7b7e\u5230\u7ec4\u4e0d\u5339\u914d!", (Object[])new Object[0]);
        SignInTypeEntity typeEntity2 = (SignInTypeEntity)((Object)this.signInTypeRepository.getById((Serializable)((Object)dto.getSignInTypeId())));
        Validate.notNull((Object)((Object)typeEntity2), (String)"\u7b7e\u5230\u7c7b\u578b\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        if (BooleanEnum.TRUE.getCapital().equals(typeEntity2.getPhotograph())) {
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)dto.getPictureList()) ? 1 : 0) != 0, (String)"\u7b7e\u5230\u7167\u7247\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        }
        if (BooleanEnum.TRUE.getCapital().equals(typeEntity2.getAppointTime())) {
            Validate.isTrue((typeEntity2.getBeginTime().compareTo(dto.getSignInTime()) <= 0 && typeEntity2.getEndTime().compareTo(dto.getSignInTime()) >= 0 ? 1 : 0) != 0, (String)"\u5f53\u524d\u65f6\u95f4\u4e0d\u80fd\u7b7e\u5230", (Object[])new Object[0]);
        }
        String signInPlaceStatus = this.validatePlace(dto, groupEntity);
        dto.setSignInPlaceStatus(signInPlaceStatus);
    }

    private String validatePlace(SignInRecordDto dto, SignInGroupEntity groupEntity) {
        String electronFenceType = groupEntity.getElectronFenceType();
        String signInPlaceStatus = SignInPlaceStatus.EX.getDictCode();
        if (StringUtils.isBlank((CharSequence)electronFenceType) || SignInElectronFenceType.NONE.getDictCode().equals(electronFenceType)) {
            signInPlaceStatus = SignInPlaceStatus.OK.getDictCode();
            return signInPlaceStatus;
        }
        if (SignInElectronFenceType.OUT_SIGN_OK.getDictCode().equals(electronFenceType)) {
            signInPlaceStatus = SignInPlaceStatus.OK.getDictCode();
            return signInPlaceStatus;
        }
        List<SignInGroupPlaceEntity> placeList = groupEntity.getPlaceList();
        Validate.isTrue((!CollectionUtils.isEmpty(placeList) ? 1 : 0) != 0, (String)"\u4e0d\u5141\u8bb8\u7b7e\u5230\u8303\u56f4\u5916\u7b7e\u5230", (Object[])new Object[0]);
        for (SignInGroupPlaceEntity placeEntity : placeList) {
            double distance = DistanceUtil.calculatePointDistance((double)dto.getSignInLatitude().doubleValue(), (double)dto.getSignInLongitude().doubleValue(), (double)placeEntity.getPlaceLatitude().doubleValue(), (double)placeEntity.getPlaceLongitude().doubleValue());
            if (BigDecimal.valueOf(placeEntity.getPlaceRange().intValue()).compareTo(BigDecimal.valueOf(distance)) >= 0) {
                signInPlaceStatus = SignInPlaceStatus.OK.getDictCode();
            }
            if (!SignInPlaceStatus.OK.getDictCode().equals(signInPlaceStatus)) continue;
            break;
        }
        Validate.isTrue((!SignInPlaceStatus.EX.getDictCode().equals(signInPlaceStatus) || !SignInElectronFenceType.NO_OUT_SIGN.getDictCode().equals(electronFenceType) ? 1 : 0) != 0, (String)"\u4e0d\u5141\u8bb8\u7b7e\u5230\u8303\u56f4\u5916\u7b7e\u5230", (Object[])new Object[0]);
        return signInPlaceStatus;
    }

    private void createValidation(SignInRecordDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setId(null);
        LoginUserDetails loginDetails = (LoginUserDetails)this.loginUserService.getLoginDetails(LoginUserDetails.class);
        dto.setUserName(loginDetails.getAccount());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setSignInDate(LocalDateTime.now().format(SignInConstant.YYYY_MM_DD));
        dto.setSignInTime(LocalDateTime.now().format(SignInConstant.HH_MM_SS));
        Validate.notNull((Object)dto.getGroupId(), (String)"\u7f3a\u5931\u7b7e\u5230\u7ec4", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSignInTypeId(), (String)"\u7f3a\u5931\u7b7e\u5230\u7c7b\u578b", (Object[])new Object[0]);
        SignInConditionModel model = new SignInConditionModel();
        model.setGroupId(dto.getGroupId());
        model.setSignInDate(dto.getSignInDate());
        model.setTenantCode(dto.getTenantCode());
        model.setSignInTypeId(dto.getSignInTypeId());
        model.setUserName(dto.getUserName());
        List<SignInRecordEntity> recordEntities = this.signInRecordRepository.findBySignInConditionModel(model);
        Validate.isTrue((boolean)CollectionUtils.isEmpty(recordEntities), (String)"\u5f53\u524d\u7b7e\u5230\u7c7b\u578b\u5df2\u7ecf\u7b7e\u5230\uff0c\u8bf7\u52ff\u91cd\u590d\u7b7e\u5230\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getSignInLatitude(), (String)"\u7f3a\u5931\u5b9a\u4f4d\u4fe1\u606f", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getSignInLatitude(), (String)"\u7f3a\u5931\u5b9a\u4f4d\u4fe1\u606f", (Object[])new Object[0]);
    }
}

