/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.sign.in.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.sfa.business.sign.in.local.entity.SignInTypeEntity;
import com.biz.crm.sfa.business.sign.in.local.repository.SignInTypeRepository;
import com.biz.crm.sfa.business.sign.in.local.service.SignInTypeService;
import com.biz.crm.sfa.business.sign.in.sdk.dto.SignInTypeDto;
import com.biz.crm.sfa.business.sign.in.sdk.dto.SignInTypePageDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="signInTypeService")
public class SignInTypeServiceImpl
implements SignInTypeService {
    private static final Logger log = LoggerFactory.getLogger(SignInTypeServiceImpl.class);
    @Autowired
    private SignInTypeRepository signInTypeRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public SignInTypeEntity create(SignInTypeDto dto) {
        this.createValidation(dto);
        SignInTypeEntity entity = (SignInTypeEntity)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, SignInTypeEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.signInTypeRepository.save((Object)entity);
        return entity;
    }

    @Override
    @Transactional
    public SignInTypeEntity update(SignInTypeDto dto) {
        this.updateValidation(dto);
        SignInTypeEntity entity = (SignInTypeEntity)((Object)this.signInTypeRepository.getById((Serializable)((Object)dto.getId())));
        Validate.notNull((Object)((Object)entity), (String)"\u7b7e\u5230\u7c7b\u578b\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        SignInTypeEntity updateEntity = (SignInTypeEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, SignInTypeEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.signInTypeRepository.updateById((Object)updateEntity);
        return updateEntity;
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List entities = this.signInTypeRepository.listByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u5220\u9664\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.signInTypeRepository.updateDelFlagByIds(ids);
    }

    @Override
    public Page<SignInTypeEntity> findByConditions(Pageable pageable, SignInTypePageDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (SignInTypePageDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new SignInTypePageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.signInTypeRepository.findByConditions(pageable, dto);
    }

    @Override
    public SignInTypeEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (SignInTypeEntity)((Object)this.signInTypeRepository.getById((Serializable)((Object)id)));
    }

    private void createValidation(SignInTypeDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setId(null);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getTypeName(), (String)"\u7f3a\u5931\u7c7b\u578b\u540d\u79f0", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getAppointTime(), (String)"\u7f3a\u5931\u662f\u5426\u6307\u5b9a\u65f6\u95f4", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getPhotograph(), (String)"\u7f3a\u5931\u662f\u5426\u62cd\u7167", (Object[])new Object[0]);
        if (BooleanEnum.TRUE.getCapital().equals(dto.getAppointTime())) {
            Validate.notBlank((CharSequence)dto.getBeginTime(), (String)"\u7f3a\u5931\u6253\u5361\u5f00\u59cb\u65f6\u95f4", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)dto.getEndTime(), (String)"\u7f3a\u5931\u6253\u5361\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
            Validate.isTrue((boolean)this.validateTimeFormat(dto.getBeginTime()), (String)"\u975e\u6cd5\u7684\u6253\u5361\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f,\u53ef\u7528\u7684\u683c\u5f0f:[HH:mm:ss]", (Object[])new Object[0]);
            Validate.isTrue((boolean)this.validateTimeFormat(dto.getEndTime()), (String)"\u975e\u6cd5\u7684\u6253\u5361\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f,\u53ef\u7528\u7684\u683c\u5f0f:[HH:mm:ss]", (Object[])new Object[0]);
            Validate.isTrue((dto.getBeginTime().compareTo(dto.getEndTime()) < 0 ? 1 : 0) != 0, (String)"\u6253\u5361\u5f00\u59cb\u65f6\u95f4\u9700\u65e9\u4e8e\u6253\u5f00\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        } else {
            dto.setBeginTime(null);
            dto.setEndTime(null);
        }
    }

    private void updateValidation(SignInTypeDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getTypeName(), (String)"\u7f3a\u5931\u7c7b\u578b\u540d\u79f0", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getAppointTime(), (String)"\u7f3a\u5931\u662f\u5426\u6307\u5b9a\u65f6\u95f4", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getPhotograph(), (String)"\u7f3a\u5931\u662f\u5426\u62cd\u7167", (Object[])new Object[0]);
        if (BooleanEnum.TRUE.getCapital().equals(dto.getAppointTime())) {
            Validate.notBlank((CharSequence)dto.getEndTime(), (String)"\u7f3a\u5931\u6253\u5361\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)dto.getBeginTime(), (String)"\u7f3a\u5931\u6253\u5361\u5f00\u59cb\u65f6\u95f4", (Object[])new Object[0]);
            Validate.isTrue((boolean)this.validateTimeFormat(dto.getBeginTime()), (String)"\u975e\u6cd5\u7684\u6253\u5361\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f,\u53ef\u7528\u7684\u683c\u5f0f:[HH:mm:ss]", (Object[])new Object[0]);
            Validate.isTrue((boolean)this.validateTimeFormat(dto.getEndTime()), (String)"\u975e\u6cd5\u7684\u6253\u5361\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f,\u53ef\u7528\u7684\u683c\u5f0f:[HH:mm:ss]", (Object[])new Object[0]);
            Validate.isTrue((dto.getBeginTime().compareTo(dto.getEndTime()) < 0 ? 1 : 0) != 0, (String)"\u6253\u5361\u5f00\u59cb\u65f6\u95f4\u9700\u65e9\u4e8e\u6253\u5f00\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        } else {
            dto.setBeginTime(null);
            dto.setEndTime(null);
        }
    }

    private Boolean validateTimeFormat(String timeStr) {
        Boolean result;
        try {
            LocalTime.parse(timeStr, DateTimeFormatter.ofPattern("HH:mm:ss"));
            result = Boolean.TRUE;
        }
        catch (Exception e) {
            result = Boolean.FALSE;
        }
        return result;
    }
}

