package com.biz.crm.sfa.business.sign.in.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.sign.in.local.entity.SignInGroupEntity;
import com.biz.crm.sfa.business.sign.in.local.service.SignInGroupService;
import com.biz.crm.sfa.business.sign.in.sdk.dto.SignInGroupDto;
import com.biz.crm.sfa.business.sign.in.sdk.dto.SignInGroupPageDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 签到组: SignInGroup: 签到组配置
 *
 * @author ning.zhang
 * @date 2022/5/9
 */
@Slf4j
@RestController
@RequestMapping("/v1/signIn/signInGroup")
@Api(tags = "签到组: SignInGroup: 签到组配置")
public class SignInGroupController {

  @Autowired
  private SignInGroupService signInGroupService;

  /**
   * 新增签到组信息
   *
   * @param dto 参数dto
   * @return 新增签到组数据
   */
  @ApiOperation(value = "新增签到组")
  @PostMapping("")
  public Result<SignInGroupEntity> create(@RequestBody SignInGroupDto dto) {
    try {
      return Result.ok(this.signInGroupService.create(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新签到组信息
   *
   * @param dto 参数dto
   * @return 更新后签到组数据
   */
  @ApiOperation(value = "更新签到组信息")
  @PatchMapping("")
  public Result<SignInGroupEntity> update(@RequestBody SignInGroupDto dto) {
    try {
      return Result.ok(this.signInGroupService.update(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 删除签到组
   *
   * @param ids 签到组id集合
   * @return 操作结果
   */
  @ApiOperation(value = "删除")
  @DeleteMapping("/deleteBatch")
  public Result deleteBatch(@RequestParam("ids") List<String> ids) {
    try {
      this.signInGroupService.deleteBatch(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用签到组
   *
   * @param ids 签到组id集合
   * @return 操作结果
   */
  @ApiOperation(value = "启用")
  @PatchMapping("/enableBatch")
  public Result enableBatch(@RequestBody List<String> ids) {
    try {
      this.signInGroupService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用签到组
   *
   * @param ids 签到组id集合
   * @return 操作结果
   */
  @ApiOperation(value = "禁用")
  @PatchMapping("/disableBatch")
  public Result disableBatch(@RequestBody List<String> ids) {
    try {
      this.signInGroupService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 签到组分页查询
   *
   * @param pageable 分页信息
   * @param dto      参数Dto
   * @return 签到组分页数据
   */
  @ApiOperation(value = "签到组分页查询")
  @GetMapping("/findByConditions")
  public Result<Page<SignInGroupEntity>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                          @ApiParam(name = "SignInGroupPageDto", value = "分页Dto") SignInGroupPageDto dto) {
    try {
      return Result.ok(this.signInGroupService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
