package com.biz.crm.sfa.business.sign.in.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.sign.in.local.entity.SignInRecordEntity;
import com.biz.crm.sfa.business.sign.in.local.service.SignInRecordService;
import com.biz.crm.sfa.business.sign.in.sdk.dto.SignInRecordDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 签到组: SignInRecord: 签到记录
 *
 * @author ning.zhang
 * @date 2022/5/23
 */
@Slf4j
@RestController
@RequestMapping("/v1/signIn/signInRecord")
@Api(tags = "签到组: SignInRecord: 签到记录")
public class SignInRecordController {

  @Autowired
  private SignInRecordService signInRecordService;

  /**
   * 移动端-创建自由签到记录
   *
   * @param dto 参数dto
   * @return 签到记录
   */
  @ApiOperation(value = "移动端-创建自由签到记录")
  @PostMapping("")
  public Result<SignInRecordEntity> create(@RequestBody SignInRecordDto dto) {
    try {
      return Result.ok(this.signInRecordService.create(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
