package com.biz.crm.sfa.business.sign.in.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.sign.in.sdk.service.SignInRecordVoService;
import com.biz.crm.sfa.business.sign.in.sdk.vo.SignInRecordVo;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 签到组: SignInRecordVo: 签到记录
 *
 * @author ning.zhang
 * @date 2022/5/23
 */
@Slf4j
@RestController
@RequestMapping("/v1/signIn/signInRecord")
@Api(tags = "签到组: SignInRecordVo: 签到记录")
public class SignInRecordVoController {

  @Autowired
  private SignInRecordVoService signInRecordVoService;

  /**
   * 通过签到记录ID查询签到记录
   *
   * @param id 签到记录ID
   * @return 签到记录
   */
  @ApiOperation(value = "通过签到记录ID查询打卡详情")
  @GetMapping("/findById")
  public Result<SignInRecordVo> findById(@RequestParam(value = "id", required = false) @ApiParam(name = "id", value = "主键ID") String id) {
    try {
      List<SignInRecordVo> list = this.signInRecordVoService.findByIds(Lists.newArrayList(id));
      return Result.ok(CollectionUtils.isEmpty(list) ? null : list.get(0));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
