package com.biz.crm.sfa.business.sign.in.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.sign.in.local.entity.SignInTypeEntity;
import com.biz.crm.sfa.business.sign.in.local.service.SignInTypeService;
import com.biz.crm.sfa.business.sign.in.sdk.dto.SignInTypeDto;
import com.biz.crm.sfa.business.sign.in.sdk.dto.SignInTypePageDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 签到组: SignInType: 签到类型配置
 *
 * @author ning.zhang
 * @date 2022/5/9
 */
@Slf4j
@RestController
@RequestMapping("/v1/signIn/signInType")
@Api(tags = "签到组: SignInType: 签到类型配置")
public class SignInTypeController {

  @Autowired
  private SignInTypeService signInTypeService;

  /**
   * 新增签到类型信息
   *
   * @param dto 参数dto
   * @return 新增签到类型数据
   */
  @ApiOperation(value = "新增签到类型")
  @PostMapping("")
  public Result<SignInTypeEntity> create(@RequestBody SignInTypeDto dto) {
    try {
      return Result.ok(this.signInTypeService.create(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新签到类型信息
   *
   * @param dto 参数dto
   * @return 更新后签到类型数据
   */
  @ApiOperation(value = "更新签到类型信息")
  @PatchMapping("")
  public Result<SignInTypeEntity> update(@RequestBody SignInTypeDto dto) {
    try {
      return Result.ok(this.signInTypeService.update(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 删除签到类型
   *
   * @param ids 签到类型id集合
   * @return 操作结果
   */
  @ApiOperation(value = "删除")
  @DeleteMapping("/deleteBatch")
  public Result deleteBatch(@RequestParam("ids") List<String> ids) {
    try {
      this.signInTypeService.deleteBatch(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 签到类型分页查询
   *
   * @param pageable 分页信息
   * @param dto      参数Dto
   * @return 签到类型分页数据
   */
  @ApiOperation(value = "签到类型分页查询")
  @GetMapping("/findByConditions")
  public Result<Page<SignInTypeEntity>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                         @ApiParam(name = "SignInTypePageDto", value = "分页Dto") SignInTypePageDto dto) {
    try {
      return Result.ok(this.signInTypeService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过签到类型ID获取签到类型信息
   *
   * @param id 签到类型ID
   * @return 签到类型信息
   */
  @ApiOperation(value = "通过签到类型ID获取签到类型信息")
  @GetMapping("/findById")
  public Result<SignInTypeEntity> findById(@RequestParam(value = "id", required = false) @ApiParam(name = "id", value = "主键ID") String id) {
    try {
      return Result.ok(this.signInTypeService.findById(id));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
