package com.biz.crm.sfa.business.sign.in.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 签到组日期实体类
 *
 * @author ning.zhang
 * @date 2022/5/9
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SignInGroupDateEntity", description = "签到组日期实体类")
@Entity
@TableName("sfa_sign_in_group_date")
@Table(name = "sfa_sign_in_group_date", indexes = {
    @Index(name = "sfa_sign_in_group_date_index1", columnList = "group_id"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_sign_in_group_date", comment = "签到组日期表")
public class SignInGroupDateEntity extends UuidOpEntity {

  private static final long serialVersionUID = 2711391527121816481L;

  /**
   * 签到组ID
   */
  @ApiModelProperty("签到组ID")
  @Column(name = "group_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '签到组ID'")
  private String groupId;

  /**
   * 时间段序号
   */
  @ApiModelProperty("时间段序号")
  @Column(name = "time_no", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '时间段序号'")
  private String timeNo;

  /**
   * 签到日期
   */
  @ApiModelProperty("签到日期")
  @Column(name = "check_in_date", length = 32, columnDefinition = "VARCHAR(32) COMMENT '签到日期'")
  private String checkInDate;

  /**
   * 开始日期
   */
  @ApiModelProperty("开始日期")
  @Column(name = "start_time", length = 32, columnDefinition = "VARCHAR(32) COMMENT '开始日期'")
  private String startTime;

  /**
   * 结束日期
   */
  @ApiModelProperty("结束日期")
  @Column(name = "end_time", length = 32, columnDefinition = "VARCHAR(32) COMMENT '结束日期'")
  private String endTime;
}
