package com.biz.crm.sfa.business.sign.in.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.List;

/**
 * 签到组实体类
 *
 * @author ning.zhang
 * @date 2022/5/9
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SignInGroupEntity", description = "签到组实体类")
@Entity
@TableName("sfa_sign_in_group")
@Table(name = "sfa_sign_in_group", indexes = {
    @Index(name = "sfa_sign_in_group_index1", columnList = "group_code", unique = true),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_sign_in_group", comment = "签到组表")
public class SignInGroupEntity extends TenantFlagOpEntity {

  private static final long serialVersionUID = 4444426038112338866L;

  /**
   * 签到组名称
   */
  @ApiModelProperty("签到组名称")
  @Column(name = "group_name", length = 128, nullable = false, columnDefinition = "VARCHAR(128) NOT NULL COMMENT '签到组名称'")
  private String groupName;

  /**
   * 签到组编码
   */
  @ApiModelProperty("签到组编码")
  @Column(name = "group_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '签到组编码'")
  private String groupCode;


  /**
   * 有效时间类型(long_time:长期有效;diy_time:自定义有效期)
   *
   * @see com.biz.crm.sfa.business.sign.in.sdk.enums.SignInTimeType
   */
  @ApiModelProperty("有效时间类型(long_time:长期有效;diy_time:自定义有效期)")
  @Column(name = "time_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '有效时间类型(long_time:长期有效;diy_time:自定义有效期)'")
  private String timeType;

  /**
   * 打卡范围类型(none:无打卡范围;out_sign_ex:允许范围外打卡，地点记录为异常;out_sign_ok:允许范围外打卡，地点记录为正常;no_out_sign:不允许范围外打卡)
   *
   * @see com.biz.crm.sfa.business.sign.in.sdk.enums.SignInElectronFenceType
   */
  @ApiModelProperty("打卡范围类型(none:无打卡范围;out_sign_ex:允许范围外打卡，地点记录为异常;out_sign_ok:允许范围外打卡，地点记录为正常;no_out_sign:不允许范围外打卡)")
  @Column(name = "electron_fence_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '打卡范围类型(none:无打卡范围;out_sign_ex:允许范围外打卡，地点记录为异常;out_sign_ok:允许范围外打卡，地点记录为正常;no_out_sign:不允许范围外打卡)'")
  private String electronFenceType;

  /**
   * 打卡日期信息
   */
  @ApiModelProperty("打卡日期信息")
  @Transient
  @TableField(exist = false)
  private List<SignInGroupDateEntity> dateList;

  /**
   * 打卡地点信息
   */
  @ApiModelProperty("打卡地点信息")
  @Transient
  @TableField(exist = false)
  private List<SignInGroupPlaceEntity> placeList;

  /**
   * 打卡范围信息
   */
  @ApiModelProperty("打卡范围信息")
  @Transient
  @TableField(exist = false)
  private List<SignInGroupScopeEntity> scopeList;

  /**
   * 签到类型信息
   */
  @ApiModelProperty("签到类型信息")
  @Transient
  @TableField(exist = false)
  private List<SignInGroupTypeEntity> typeList;
}
