package com.biz.crm.sfa.business.sign.in.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.math.BigDecimal;
import java.util.List;

/**
 * 签到记录实体类
 *
 * @author ning.zhang
 * @date 2022/5/23
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SignInRecordEntity", description = "签到记录实体类")
@Entity
@TableName("sfa_sign_in_record")
@Table(name = "sfa_sign_in_record", indexes = {
    @Index(name = "sfa_sign_in_record_index1", columnList = "group_id"),
    @Index(name = "sfa_sign_in_record_index2", columnList = "user_name"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_sign_in_record", comment = "签到记录表")
public class SignInRecordEntity extends TenantFlagOpEntity {

  private static final long serialVersionUID = -8982625203144690224L;

  /**
   * 签到组ID
   */
  @ApiModelProperty("签到组ID")
  @Column(name = "group_id", length = 64, columnDefinition = "VARCHAR(64) COMMENT '签到组ID'")
  private String groupId;

  /**
   * 签到类型ID
   */
  @ApiModelProperty("签到类型ID")
  @Column(name = "sign_in_type_id", length = 64, columnDefinition = "VARCHAR(64) COMMENT '签到类型ID'")
  private String signInTypeId;

  /**
   * 签到人员帐号
   */
  @ApiModelProperty("签到人员帐号")
  @Column(name = "user_name", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '签到人员帐号'")
  private String userName;

  /**
   * 打卡人员账号
   */
  @ApiModelProperty("打卡人员姓名")
  @Column(name = "user_real_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '打卡人员姓名'")
  private String userRealName;

  /**
   * 职位编码
   */
  @Column(name = "post_code", columnDefinition = "VARCHAR(64) COMMENT '职位编码'")
  @ApiModelProperty("职位编码")
  private String postCode;

  /**
   * 职位名称
   */
  @Column(name = "post_name", columnDefinition = "VARCHAR(64) COMMENT '职位名称'")
  @ApiModelProperty("职位名称")
  private String postName;

  /**
   * 组织编码
   */
  @Column(name = "org_code", columnDefinition = "VARCHAR(64)  COMMENT '组织编码'")
  @ApiModelProperty("组织编码")
  private String orgCode;

  /**
   * 组织名称
   */
  @Column(name = "org_name", columnDefinition = "VARCHAR(64) COMMENT '组织名称'")
  @ApiModelProperty("组织名称")
  private String orgName;

  /**
   * 签到时间(HH:mm:ss)
   */
  @ApiModelProperty("签到时间(HH:mm:ss)")
  @Column(name = "sign_in_time", length = 30, columnDefinition = "VARCHAR(30) COMMENT '签到时间(HH:mm:ss)'")
  private String signInTime;

  /**
   * 签到日期(YYYY-MM-DD)
   */
  @ApiModelProperty("签到日期(YYYY-MM-DD)")
  @Column(name = "sign_in_date", length = 30, columnDefinition = "VARCHAR(30) COMMENT '签到日期(YYYY-MM-DD)'")
  private String signInDate;

  /**
   * 签到经度
   */
  @ApiModelProperty("签到经度")
  @Column(name = "sign_in_longitude", columnDefinition = "decimal(12,8) COMMENT '签到经度'")
  private BigDecimal signInLongitude;

  /**
   * 签到纬度
   */
  @ApiModelProperty("签到纬度")
  @Column(name = "sign_in_latitude", columnDefinition = "decimal(12,8) COMMENT '签到纬度'")
  private BigDecimal signInLatitude;

  /**
   * 签到地点
   */
  @ApiModelProperty("签到地点")
  @Column(name = "sign_in_place", length = 400, columnDefinition = "VARCHAR(400) COMMENT '签到地点(HH:mm:ss)'")
  private String signInPlace;

  /**
   * 签到地点状态(ok:正常;ex:异常)
   *
   * @see com.biz.crm.sfa.business.sign.in.sdk.enums.SignInPlaceStatus
   */
  @ApiModelProperty("签到地点状态(ok:正常;ex:异常)")
  @Column(name = "sign_in_place_status", length = 32, columnDefinition = "VARCHAR(32) COMMENT '签到地点状态(ok:正常;ex:异常)'")
  private String signInPlaceStatus;

  /**
   * 签到状态(ok:正常;error:异常;none:未打卡)
   *
   * @see com.biz.crm.sfa.business.sign.in.sdk.enums.SignInStatus
   */
  @ApiModelProperty("签到状态(ok:正常;error:异常;none:未打卡)")
  @Column(name = "sign_in_status", length = 32, columnDefinition = "VARCHAR(32) COMMENT '签到状态(ok:正常;error:异常;none:未打卡)'")
  private String signInStatus;

  /**
   * 签到照片
   */
  @ApiModelProperty("签到照片")
  @Transient
  @TableField(exist = false)
  private List<SignInRecordPictureEntity> pictureList;

  /**
   * 签到组名称
   */
  @ApiModelProperty("签到组名称")
  @Transient
  @TableField(exist = false)
  private String groupName;

  /**
   * 签到类型名称
   */
  @ApiModelProperty("签到类型名称")
  @Transient
  @TableField(exist = false)
  private String signInTypeName;

}
