package com.biz.crm.sfa.business.sign.in.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.FileEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 签到记录照片实体类
 *
 * @author ning.zhang
 * @date 2022/5/18
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SignInRecordPictureEntity", description = "签到记录照片实体类")
@Entity
@TableName("sfa_sign_in_record_picture")
@Table(name = "sfa_sign_in_record_picture", indexes = {
    @Index(name = "sfa_sign_in_record_picture_index1", columnList = "record_id"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_sign_in_record_picture", comment = "签到记录照片表")
public class SignInRecordPictureEntity extends FileEntity {

  private static final long serialVersionUID = 3460601362198321611L;

  /**
   * 签到记录ID
   */
  @ApiModelProperty("签到记录ID")
  @Column(name = "record_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '签到记录ID'")
  private String recordId;

}
