package com.biz.crm.sfa.business.sign.in.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 签到类型实体类
 *
 * @author ning.zhang
 * @date 2022/5/9
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SignInTypeEntity", description = "签到类型实体类")
@Entity
@TableName("sfa_sign_in_type")
@Table(name = "sfa_sign_in_type")
@org.hibernate.annotations.Table(appliesTo = "sfa_sign_in_type", comment = "签到类型表")
public class SignInTypeEntity extends TenantFlagOpEntity {


  private static final long serialVersionUID = 8433308883444727114L;

  /**
   * 序号
   */
  @ApiModelProperty("序号")
  @Column(name = "line_no", length = 5, columnDefinition = "INT(5) COMMENT '序号'")
  private Integer lineNo;

  /**
   * 类型名称
   */
  @ApiModelProperty("类型名称")
  @Column(name = "type_name", length = 128, nullable = false, columnDefinition = "VARCHAR(128) NOT NULL COMMENT '类型名称'")
  private String typeName;


  /**
   * 是否拍照(Y:是,N:否)
   *
   * @see com.biz.crm.business.common.sdk.enums.BooleanEnum
   */
  @ApiModelProperty("是否拍照(Y:是,N:否)")
  @Column(name = "photograph", length = 32, nullable = false, columnDefinition = "VARCHAR(32) NOT NULL COMMENT '是否拍照(Y:是,N:否)'")
  private String photograph;

  /**
   * 是否指定时间(Y:是,N:否)
   *
   * @see com.biz.crm.business.common.sdk.enums.BooleanEnum
   */
  @ApiModelProperty("是否指定时间(Y:是,N:否)")
  @Column(name = "appoint_time", length = 32, nullable = false, columnDefinition = "VARCHAR(32) NOT NULL COMMENT '是否指定时间(Y:是,N:否)'")
  private String appointTime;

  /**
   * 开始时间
   */
  @ApiModelProperty("打卡开始时间")
  @Column(name = "begin_time", length = 32, columnDefinition = "VARCHAR(32) COMMENT '开始时间'")
  private String beginTime;

  /**
   * 结束时间
   */
  @ApiModelProperty("打卡结束时间")
  @Column(name = "end_time", length = 32, columnDefinition = "VARCHAR(32) COMMENT '结束时间'")
  private String endTime;
}
