package com.biz.crm.sfa.business.sign.in.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.sfa.business.sign.in.local.entity.SignInRecordEntity;
import com.biz.crm.sfa.business.sign.in.local.model.SignInConditionModel;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 签到记录表的mybatis-plus接口类 {@link SignInRecordEntity}
 *
 * @author ning.zhang
 * @date 2022-05-23 10:18:39
 */
public interface SignInRecordMapper extends BaseMapper<SignInRecordEntity> {

  /**
   * 多条件查询考勤规则列表
   *
   * @param model 条件model
   * @return 考勤规则列表
   */
  List<SignInRecordEntity> findBySignInConditionModel(@Param("model") SignInConditionModel model);

  /**
   * 通过签到记录ID集合获取签到记录信息
   *
   * @param ids 签到记录ID集合
   * @return 签到记录信息
   */
  List<SignInRecordEntity> findByIds(@Param("ids") List<String> ids);
}

