package com.biz.crm.sfa.business.sign.in.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.sign.in.local.entity.SignInTypeEntity;
import com.biz.crm.sfa.business.sign.in.sdk.dto.SignInTypePageDto;
import org.apache.ibatis.annotations.Param;

/**
 * 签到类型表的mybatis-plus接口类 {@link SignInTypeEntity}
 *
 * @author ning.zhang
 * @date 2022-05-09 11:43:31
 */
public interface SignInTypeMapper extends BaseMapper<SignInTypeEntity> {

  /**
   * 签到类型分页列表
   *
   * @param dto  请求参数dto
   * @param page 分页信息
   * @return Page<SignInTypeEntity> 签到类型分页信息
   */
  Page<SignInTypeEntity> findByConditions(Page<SignInTypeEntity> page, @Param("dto") SignInTypePageDto dto);

}

