package com.biz.crm.sfa.business.sign.in.local.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 签到多条件model
 *
 * @author ning.zhang
 * @date 2022/5/23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SignInConditionModel", description = "签到多条件model")
public class SignInConditionModel {

  /**
   * 租户编号
   */
  @ApiModelProperty("租户编号")
  private String tenantCode;

  /***
   * 签到人员帐号
   */
  @ApiModelProperty("签到人员帐号")
  private String userName;

  /**
   * 签到类型ID
   */
  @ApiModelProperty("签到类型ID")
  private String signInTypeId;

  /**
   * 签到日期(YYYY-MM-DD)
   */
  @ApiModelProperty("签到日期(YYYY-MM-DD)")
  private String signInDate;

  /**
   * 签到组ID
   */
  @ApiModelProperty("签到组ID")
  private String groupId;
}
