package com.biz.crm.sfa.business.sign.in.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.sign.in.local.entity.SignInGroupPlaceEntity;
import com.biz.crm.sfa.business.sign.in.local.mapper.SignInGroupPlaceMapper;
import org.springframework.stereotype.Component;

/**
 * 签到组地点表的数据库访问类 {@link SignInGroupPlaceEntity}
 *
 * @author ning.zhang
 * @date 2022-05-09 11:42:58
 */
@Component
public class SignInGroupPlaceRepository extends ServiceImpl<SignInGroupPlaceMapper, SignInGroupPlaceEntity> {

  /**
   * 通过删除签到组ID删除签到组范围
   *
   * @param groupId 签到组ID
   */
  public void deleteByGroupId(String groupId) {
    this.lambdaUpdate()
        .eq(SignInGroupPlaceEntity::getGroupId, groupId)
        .remove();
  }
}
