package com.biz.crm.sfa.business.sign.in.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.sign.in.local.entity.SignInGroupScopeEntity;
import com.biz.crm.sfa.business.sign.in.local.mapper.SignInGroupScopeMapper;
import org.springframework.stereotype.Component;

/**
 * 签到组范围表的数据库访问类 {@link SignInGroupScopeEntity}
 *
 * @author ning.zhang
 * @date 2022-05-09 11:43:08
 */
@Component
public class SignInGroupScopeRepository extends ServiceImpl<SignInGroupScopeMapper, SignInGroupScopeEntity> {

  /**
   * 通过删除签到组ID删除签到组范围
   *
   * @param groupId 签到组ID
   */
  public void deleteByGroupId(String groupId) {
    this.lambdaUpdate()
        .eq(SignInGroupScopeEntity::getGroupId, groupId)
        .remove();
  }
}
