package com.biz.crm.sfa.business.sign.in.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.sign.in.local.entity.SignInGroupTypeEntity;
import com.biz.crm.sfa.business.sign.in.local.mapper.SignInGroupTypeMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 签到组-签到类型实体类表的数据库访问类 {@link SignInGroupTypeEntity}
 *
 * @author ning.zhang
 * @date 2022-05-09 11:43:19
 */
@Component
public class SignInGroupTypeRepository extends ServiceImpl<SignInGroupTypeMapper, SignInGroupTypeEntity> {

  /**
   * 通过删除签到组ID删除签到类型
   *
   * @param groupId 签到组ID
   */
  public void deleteByGroupId(String groupId) {
    this.lambdaUpdate()
        .eq(SignInGroupTypeEntity::getGroupId, groupId)
        .remove();
  }

  /**
   * 通过签到组ID集合获取签到组-签到类型信息
   *
   * @param groupIds 签到组ID集合
   * @return 签到组-签到类型信息
   */
  public List<SignInGroupTypeEntity> findByGroupIds(List<String> groupIds) {
    return this.lambdaQuery()
        .in(SignInGroupTypeEntity::getGroupId, groupIds)
        .list();
  }
}
