package com.biz.crm.sfa.business.sign.in.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.sign.in.local.entity.SignInRecordPictureEntity;
import com.biz.crm.sfa.business.sign.in.local.mapper.SignInRecordPictureMapper;
import org.springframework.stereotype.Component;

/**
 * 签到记录照片表的数据库访问类 {@link SignInRecordPictureEntity}
 *
 * @author ning.zhang
 * @date 2022-05-23 11:50:10
 */
@Component
public class SignInRecordPictureRepository extends ServiceImpl<SignInRecordPictureMapper, SignInRecordPictureEntity> {

  /**
   * 通过签到记录ID删除勤记录照片信息
   *
   * @param recordId 签到记录ID
   */
  public void deleteByRecordId(String recordId) {
    this.lambdaUpdate()
        .eq(SignInRecordPictureEntity::getRecordId, recordId)
        .remove();
  }
}
