package com.biz.crm.sfa.business.sign.in.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.sign.in.local.entity.SignInRecordEntity;
import com.biz.crm.sfa.business.sign.in.local.mapper.SignInRecordMapper;
import com.biz.crm.sfa.business.sign.in.local.model.SignInConditionModel;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 签到记录表的数据库访问类 {@link SignInRecordEntity}
 *
 * @author ning.zhang
 * @date 2022-05-23 10:18:40
 */
@Component
public class SignInRecordRepository extends ServiceImpl<SignInRecordMapper, SignInRecordEntity> {


  /**
   * 多条件查询签到记录列表
   *
   * @param model 条件model
   * @return 签到记录列表
   */
  public List<SignInRecordEntity> findBySignInConditionModel(SignInConditionModel model) {
    return this.baseMapper.findBySignInConditionModel(model);
  }

  /**
   * 通过签到记录ID集合获取签到记录信息
   *
   * @param ids 签到记录ID集合
   * @return 签到记录信息
   */
  public List<SignInRecordEntity> findByIds(List<String> ids) {
    return this.baseMapper.findByIds(ids);
  }
}
