package com.biz.crm.sfa.business.sign.in.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.sfa.business.sign.in.local.entity.SignInTypeEntity;
import com.biz.crm.sfa.business.sign.in.local.mapper.SignInTypeMapper;
import com.biz.crm.sfa.business.sign.in.sdk.dto.SignInTypePageDto;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 签到类型表的数据库访问类 {@link SignInTypeEntity}
 *
 * @author ning.zhang
 * @date 2022-05-09 11:43:32
 */
@Component
public class SignInTypeRepository extends ServiceImpl<SignInTypeMapper, SignInTypeEntity> {

  /**
   * 签到类型分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<SignInTypeEntity> 签到类型分页信息
   */
  public Page<SignInTypeEntity> findByConditions(Pageable pageable, SignInTypePageDto dto) {
    Page<SignInTypeEntity> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findByConditions(page, dto);
  }
  /**
   * 批量删除
   *
   * @param ids ID集合
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(SignInTypeEntity::getId, ids)
        .set(SignInTypeEntity::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }
}
