package com.biz.crm.sfa.business.sign.in.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.sign.in.local.entity.SignInGroupEntity;
import com.biz.crm.sfa.business.sign.in.sdk.dto.SignInGroupDto;
import com.biz.crm.sfa.business.sign.in.sdk.dto.SignInGroupPageDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 签到组表服务接口
 *
 * @author ning.zhang
 * @date 2022-05-09 11:42:29
 */
public interface SignInGroupService {

  /**
   * 创建签到类型
   *
   * @param dto 请求参数dto
   * @return 签到类型实体
   */
  SignInGroupEntity create(SignInGroupDto dto);

  /**
   * 更新签到类型
   *
   * @param dto 请求参数dto
   * @return 签到类型实体
   */
  SignInGroupEntity update(SignInGroupDto dto);

  /**
   * 批量删除签到类型
   *
   * @param ids 签到类型id集合
   */
  void deleteBatch(List<String> ids);

  /**
   * 批量启用签到类型
   *
   * @param ids 签到类型id集合
   */
  void enableBatch(List<String> ids);

  /**
   * 批量禁用签到类型
   *
   * @param ids 签到类型id集合
   */
  void disableBatch(List<String> ids);

  /**
   * 签到组分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<SignInGroupEntity> 签到组分页信息
   */
  Page<SignInGroupEntity> findByConditions(Pageable pageable, SignInGroupPageDto dto);
}
