package com.biz.crm.sfa.business.sign.in.local.service.internal;

import com.biz.crm.sfa.business.sign.in.local.entity.SignInGroupTypeEntity;
import com.biz.crm.sfa.business.sign.in.local.repository.SignInGroupTypeRepository;
import com.biz.crm.sfa.business.sign.in.local.service.SignInGroupTypeService;
import com.biz.crm.sfa.business.sign.in.sdk.dto.SignInGroupDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 签到组-签到类型实体类表服务实现类
 *
 * @author ning.zhang
 * @date 2022-05-09 11:43:19
 */
@Slf4j
@Service("signInGroupTypeService")
public class SignInGroupTypeServiceImpl implements SignInGroupTypeService {

  @Autowired
  private SignInGroupTypeRepository signInGroupTypeRepository;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  @Transactional
  public void update(SignInGroupDto dto) {
    Validate.notBlank(dto.getId(), "签到组ID不能为空");
    this.signInGroupTypeRepository.deleteByGroupId(dto.getId());
    if (CollectionUtils.isEmpty(dto.getTypeList())) {
      return;
    }
    this.updateValidation(dto);
    List<SignInGroupTypeEntity> entities = dto.getTypeList().stream().map(typeDto -> {
      SignInGroupTypeEntity entity = this.nebulaToolkitService.copyObjectByWhiteList(typeDto, SignInGroupTypeEntity.class, HashSet.class, ArrayList.class);
      entity.setGroupId(dto.getId());
      return entity;
    }).collect(Collectors.toList());
    this.signInGroupTypeRepository.saveBatch(entities);
  }

  /**
   * 在修改signInGroupType模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   *
   * @param dto 检查对象
   */
  private void updateValidation(SignInGroupDto dto) {
    dto.getTypeList().forEach(typeDto -> {
      Validate.notBlank(typeDto.getTypeId(), "缺失签到类型ID");
    });
  }
}
