package com.biz.crm.sfa.business.sign.in.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.org.sdk.service.OrgPositionVoService;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgPositionVo;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserPositionVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserPositionVo;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.sfa.business.sign.in.local.entity.SignInGroupEntity;
import com.biz.crm.sfa.business.sign.in.local.entity.SignInGroupTypeEntity;
import com.biz.crm.sfa.business.sign.in.local.entity.SignInTypeEntity;
import com.biz.crm.sfa.business.sign.in.local.repository.SignInGroupRepository;
import com.biz.crm.sfa.business.sign.in.local.repository.SignInGroupTypeRepository;
import com.biz.crm.sfa.business.sign.in.local.repository.SignInTypeRepository;
import com.biz.crm.sfa.business.sign.in.sdk.constant.SignInConstant;
import com.biz.crm.sfa.business.sign.in.sdk.dto.SignInGroupPageDto;
import com.biz.crm.sfa.business.sign.in.sdk.dto.SignInGroupUserPageDto;
import com.biz.crm.sfa.business.sign.in.sdk.enums.SignInScopeType;
import com.biz.crm.sfa.business.sign.in.sdk.service.SignInGroupVoService;
import com.biz.crm.sfa.business.sign.in.sdk.vo.SignInGroupScopeVo;
import com.biz.crm.sfa.business.sign.in.sdk.vo.SignInGroupTypeVo;
import com.biz.crm.sfa.business.sign.in.sdk.vo.SignInGroupVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 签到组Vo服务接口实现类
 *
 * @author ning.zhang
 * @date 2022/5/10
 */
@Slf4j
@Service
public class SignInGroupVoServiceImpl implements SignInGroupVoService {

  @Autowired
  private SignInGroupRepository signInGroupRepository;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;
  @Autowired
  private OrgVoService orgVoService;
  @Autowired
  private UserFeignVoService userFeignVoService;
  @Autowired
  private SignInTypeRepository signInTypeRepository;
  @Autowired
  private LoginUserService loginUserService;
  @Autowired
  private SignInGroupTypeRepository signInGroupTypeRepository;
  @Autowired
  private UserPositionVoService userPositionVoService;
  @Autowired
  private OrgPositionVoService orgPositionVoService;

  @Override
  public SignInGroupVo findById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    List<SignInGroupEntity> entities = this.signInGroupRepository.findByIds(Lists.newArrayList(id));
    if (CollectionUtils.isEmpty(entities)) {
      return null;
    }
    SignInGroupVo signInGroupVo = this.nebulaToolkitService.copyObjectByBlankList(entities.get(0), SignInGroupVo.class, HashSet.class, ArrayList.class);
    this.perfectScopeInfo(Lists.newArrayList(signInGroupVo));
    this.perfectTypeInfo(Lists.newArrayList(signInGroupVo));
    return signInGroupVo;
  }

  @Override
  public Page<SignInGroupVo> findBySignInGroupUserPageDto(Pageable pageable, SignInGroupUserPageDto dto) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    SignInGroupPageDto groupPageDto = new SignInGroupPageDto();
    groupPageDto.setTenantCode(TenantUtils.getTenantCode());
    groupPageDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    groupPageDto.setSignInDate(LocalDateTime.now().format(SignInConstant.YYYY_MM_DD));
    FacturerUserDetails loginDetails = this.loginUserService.getLoginDetails(FacturerUserDetails.class);
    groupPageDto.setOrgCodes(Sets.newHashSet(loginDetails.getOrgCode()));
    groupPageDto.setUserName(loginDetails.getAccount());
    //查询用户关联的所有组织
    List<UserPositionVo> userPositionList = this.userPositionVoService.findByUserName(TenantUtils.getTenantCode(), groupPageDto.getUserName());
    if (!CollectionUtils.isEmpty(userPositionList)) {
      List<OrgPositionVo> orgPositionList = this.orgPositionVoService.findByPositionCodes(userPositionList.stream().map(UserPositionVo::getPositionCode).collect(Collectors.toList()));
      if (!CollectionUtils.isEmpty(orgPositionList)) {
        groupPageDto.getOrgCodes().addAll(orgPositionList.stream().map(OrgPositionVo::getOrgCode).collect(Collectors.toList()));
      }
    }
    Page<SignInGroupEntity> entityPage = this.signInGroupRepository.findByConditions(pageable, groupPageDto);
    Page<SignInGroupVo> pageResult = new Page<>(entityPage.getCurrent(), entityPage.getSize(), entityPage.getTotal());
    if (CollectionUtils.isEmpty(entityPage.getRecords())) {
      return pageResult;
    }
    List<SignInGroupVo> list = (List<SignInGroupVo>) this.nebulaToolkitService.copyCollectionByBlankList(entityPage.getRecords()
        , SignInGroupEntity.class, SignInGroupVo.class, HashSet.class, ArrayList.class);
    this.perfectTypeInfo(list);
    pageResult.setRecords(list);
    return pageResult;
  }

  /**
   * 完善签到类型信息
   *
   * @param groupList 签到组信息
   */
  private void perfectTypeInfo(List<SignInGroupVo> groupList) {
    if (CollectionUtils.isEmpty(groupList)) {
      return;
    }
    List<String> groupIds = groupList.stream().map(SignInGroupVo::getId).collect(Collectors.toList());
    List<SignInGroupTypeEntity> groupTypeEntities = this.signInGroupTypeRepository.findByGroupIds(groupIds);
    if (CollectionUtils.isEmpty(groupTypeEntities)) {
      return;
    }
    Set<String> typeIds = groupTypeEntities.stream().map(SignInGroupTypeEntity::getTypeId).collect(Collectors.toSet());
    List<SignInTypeEntity> typeEntities = this.signInTypeRepository.listByIds(typeIds);
    if (CollectionUtils.isEmpty(typeEntities)) {
      return;
    }
    Map<String, SignInTypeEntity> typeMap = typeEntities.stream().collect(Collectors.toMap(SignInTypeEntity::getId, t -> t, (a, b) -> a));
    Map<String, List<String>> groupTypeMap = groupTypeEntities.stream().collect(Collectors.groupingBy(
        SignInGroupTypeEntity::getGroupId,
        Collectors.mapping(SignInGroupTypeEntity::getTypeId, Collectors.toList())
    ));
    groupList.forEach(signInGroupVo -> {
      List<String> groupTypeIds = groupTypeMap.get(signInGroupVo.getId());
      if (CollectionUtils.isEmpty(groupTypeIds)) {
        return;
      }
      List<SignInGroupTypeVo> typeList = groupTypeIds.stream().map(typeId -> {
        SignInTypeEntity entity = typeMap.get(typeId);
        if (Objects.isNull(entity)) {
          return null;
        }
        SignInGroupTypeVo groupTypeVo = new SignInGroupTypeVo();
        groupTypeVo.setTypeId(typeId);
        groupTypeVo.setTypeName(entity.getTypeName());
        return groupTypeVo;
      }).collect(Collectors.toList());
      signInGroupVo.setTypeList(typeList);
    });
  }

  /**
   * 完善签到组范围信息
   *
   * @param groupList 签到组信息
   */
  private void perfectScopeInfo(List<SignInGroupVo> groupList) {
    if (CollectionUtils.isEmpty(groupList)) {
      return;
    }
    List<SignInGroupScopeVo> scopeList = groupList.stream().filter(vo -> !CollectionUtils.isEmpty(vo.getScopeList()))
        .flatMap(vo -> vo.getScopeList().stream()).collect(Collectors.toList());
    if (CollectionUtils.isEmpty(scopeList)) {
      return;
    }
    Set<String> orgCodes = Sets.newHashSet();
    Set<String> userNames = Sets.newHashSet();
    scopeList.forEach(scopeVo -> {
      if (SignInScopeType.ORG.getDictCode().equals(scopeVo.getScopeType())) {
        orgCodes.add(scopeVo.getScopeCode());
      }
      if (SignInScopeType.USER.getDictCode().equals(scopeVo.getScopeType())) {
        userNames.add(scopeVo.getScopeCode());
      }
    });
    Map<String, OrgVo> orgMap = this.buildOrgMap(orgCodes);
    Map<String, UserVo> userMap = this.buildUserMap(userNames);
    for (SignInGroupScopeVo scopeVo : scopeList) {
      if (SignInScopeType.ORG.getDictCode().equals(scopeVo.getScopeType())) {
        OrgVo orgVo = orgMap.getOrDefault(scopeVo.getScopeCode(), new OrgVo());
        scopeVo.setScopeName(orgVo.getOrgName());
      }
      if (SignInScopeType.USER.getDictCode().equals(scopeVo.getScopeType())) {
        UserVo userVo = userMap.getOrDefault(scopeVo.getScopeCode(), new UserVo());
        scopeVo.setScopeName(userVo.getFullName());
      }
    }
  }

  /**
   * 封装用户映射MAP
   *
   * @param userNames 用户名集合
   * @return 用户映射MAP
   */
  private Map<String, UserVo> buildUserMap(Set<String> userNames) {
    Map<String, UserVo> userMap = Maps.newHashMap();
    if (!CollectionUtils.isEmpty(userNames)) {
      List<UserVo> userList = this.userFeignVoService.findByUserNames(Lists.newArrayList(userNames));
      if (!CollectionUtils.isEmpty(userList)) {
        userMap = userList.stream().collect(Collectors.toMap(UserVo::getUserName, t -> t, (a, b) -> b));
      }
    }
    return userMap;
  }

  /**
   * 封装组织映射MAP
   *
   * @param orgCodes 组织编码
   * @return 组织映射MAP
   */
  private Map<String, OrgVo> buildOrgMap(Set<String> orgCodes) {
    Map<String, OrgVo> orgMap = Maps.newHashMap();
    if (!CollectionUtils.isEmpty(orgCodes)) {
      List<OrgVo> orgList = this.orgVoService.findByOrgCodes(Lists.newArrayList(orgCodes));
      if (!CollectionUtils.isEmpty(orgList)) {
        orgMap = orgList.stream().collect(Collectors.toMap(OrgVo::getOrgCode, t -> t, (a, b) -> b));
      }
    }
    return orgMap;
  }
}
