package com.biz.crm.sfa.business.sign.in.local.service.internal;

import com.biz.crm.sfa.business.sign.in.local.entity.SignInRecordPictureEntity;
import com.biz.crm.sfa.business.sign.in.local.repository.SignInRecordPictureRepository;
import com.biz.crm.sfa.business.sign.in.local.service.SignInRecordPictureService;
import com.biz.crm.sfa.business.sign.in.sdk.dto.SignInRecordDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 签到记录照片表服务实现类
 *
 * @author ning.zhang
 * @date 2022-05-23 11:50:10
 */
@Slf4j
@Service("signInRecordPictureService")
public class SignInRecordPictureServiceImpl implements SignInRecordPictureService {

  @Autowired
  private SignInRecordPictureRepository signInRecordPictureRepository;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  @Transactional
  public void update(SignInRecordDto dto) {
    Validate.notBlank(dto.getId(), "签到记录ID不能为空");
    this.signInRecordPictureRepository.deleteByRecordId(dto.getId());
    if (CollectionUtils.isEmpty(dto.getPictureList())) {
      return;
    }
    this.updateValidation(dto);
    List<SignInRecordPictureEntity> entities = dto.getPictureList().stream().map(pictureDto -> {
      SignInRecordPictureEntity entity = this.nebulaToolkitService.copyObjectByWhiteList(pictureDto, SignInRecordPictureEntity.class, HashSet.class, ArrayList.class);
      entity.setRecordId(dto.getId());
      entity.setTenantCode(dto.getTenantCode());
      return entity;
    }).collect(Collectors.toList());
    this.signInRecordPictureRepository.saveBatch(entities);
  }

  /**
   * 在修改AttendanceRecordPicture模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   *
   * @param dto 检查对象
   */
  private void updateValidation(SignInRecordDto dto) {
    dto.getPictureList().forEach(pictureDto -> {
      Validate.notBlank(pictureDto.getFileCode(), "缺失文件唯一识别号");
    });
  }
}
