package com.biz.crm.sfa.business.sign.in.local.service.internal;

import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.sfa.business.sign.in.local.entity.SignInRecordEntity;
import com.biz.crm.sfa.business.sign.in.local.repository.SignInRecordRepository;
import com.biz.crm.sfa.business.sign.in.sdk.service.SignInRecordVoService;
import com.biz.crm.sfa.business.sign.in.sdk.vo.SignInRecordVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * * 签到记录Vo服务接口实现
 *
 * @author ning.zhang
 * @date 2022/5/27
 */
@Slf4j
@Service
public class SignInRecordVoServiceImpl implements SignInRecordVoService {

  @Autowired
  private SignInRecordRepository signInRecordRepository;
  @Autowired
  private UserFeignVoService userFeignVoService;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public List<SignInRecordVo> findByIds(List<String> ids) {
    if (CollectionUtils.isEmpty(ids)) {
      return Lists.newLinkedList();
    }
    List<SignInRecordEntity> entities = this.signInRecordRepository.findByIds(ids);
    if (CollectionUtils.isEmpty(entities)) {
      return Lists.newLinkedList();
    }
    List<SignInRecordVo> list = (List<SignInRecordVo>) this.nebulaToolkitService.copyCollectionByBlankList(entities
        , SignInRecordEntity.class, SignInRecordVo.class, HashSet.class, ArrayList.class);
    this.perfectUserInfo(list);
    return list;
  }

  /**
   * 完善签到记录用户信息
   *
   * @param list 签到记录
   */
  private void perfectUserInfo(List<SignInRecordVo> list) {
    if (org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
      return;
    }
    Set<String> userNames = list.stream().map(SignInRecordVo::getUserName).collect(Collectors.toSet());
    List<UserVo> userVoList = this.userFeignVoService.findByUserNames(Lists.newArrayList(userNames));
    if (org.apache.commons.collections.CollectionUtils.isEmpty(userVoList)) {
      return;
    }
    Map<String, UserVo> userMap = userVoList.stream().collect(Collectors.toMap(UserVo::getUserName, t -> t, (a, b) -> b));
    list.forEach(vo -> {
      vo.setUserRealName(userMap.getOrDefault(vo.getUserName(), new UserVo()).getFullName());
    });
  }
}
