/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.sign.in.local.service.internal;

import com.biz.crm.sfa.business.sign.in.local.entity.SignInGroupDateEntity;
import com.biz.crm.sfa.business.sign.in.local.repository.SignInGroupDateRepository;
import com.biz.crm.sfa.business.sign.in.local.service.SignInGroupDateService;
import com.biz.crm.sfa.business.sign.in.sdk.dto.SignInGroupDateDto;
import com.biz.crm.sfa.business.sign.in.sdk.dto.SignInGroupDto;
import com.biz.crm.sfa.business.sign.in.sdk.enums.SignInTimeType;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="signInGroupDateService")
public class SignInGroupDateServiceImpl
implements SignInGroupDateService {
    private static final Logger log = LoggerFactory.getLogger(SignInGroupDateServiceImpl.class);
    @Autowired
    private SignInGroupDateRepository signInGroupDateRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void update(SignInGroupDto dto) {
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u7b7e\u5230\u7ec4ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.signInGroupDateRepository.deleteByGroupId(dto.getId());
        this.updateValidation(dto);
        List entities = dto.getDateList().stream().map(dateDto -> {
            SignInGroupDateEntity entity = (SignInGroupDateEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(dateDto, SignInGroupDateEntity.class, HashSet.class, ArrayList.class, new String[0])));
            entity.setGroupId(dto.getId());
            return entity;
        }).collect(Collectors.toList());
        this.signInGroupDateRepository.saveBatch(entities);
    }

    private void updateValidation(SignInGroupDto dto) {
        if (SignInTimeType.DIY_TIME.getDictCode().equals(dto.getTimeType())) {
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)dto.getDateList()) ? 1 : 0) != 0, (String)"\u7f3a\u5931\u6253\u5361\u65e5\u671f", (Object[])new Object[0]);
        } else {
            ArrayList dateList = Lists.newArrayList();
            SignInGroupDateDto dateDto2 = new SignInGroupDateDto();
            dateDto2.setStartTime(LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            dateList.add(dateDto2);
            dto.setDateList((List)dateList);
        }
        dto.getDateList().forEach(dateDto -> {
            int timeNo = dto.getDateList().indexOf(dateDto) + 1;
            dateDto.setTimeNo(String.valueOf(timeNo));
            Validate.notBlank((CharSequence)dateDto.getStartTime(), (String)String.format("\u7b2c%s\u6bb5\u6253\u5361\u65e5\u671f,\u7f3a\u5931\u5f00\u59cb\u65e5\u671f", timeNo), (Object[])new Object[0]);
            if (SignInTimeType.DIY_TIME.getDictCode().equals(dto.getTimeType())) {
                Validate.notBlank((CharSequence)dateDto.getEndTime(), (String)String.format("\u7b2c%s\u6bb5\u6253\u5361\u65e5\u671f,\u7f3a\u5931\u7ed3\u675f\u65e5\u671f", timeNo), (Object[])new Object[0]);
                Validate.isTrue((dateDto.getStartTime().compareTo(dateDto.getEndTime()) <= 0 ? 1 : 0) != 0, (String)String.format("\u7b2c%s\u6bb5\u6253\u5361\u65e5\u671f,\u5f00\u59cb\u65e5\u671f\u9700\u65e9\u4e8e\u7ed3\u675f\u65e5\u671f", timeNo), (Object[])new Object[0]);
            }
        });
    }
}

