/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.sign.in.local.service.internal;

import com.biz.crm.sfa.business.sign.in.local.entity.SignInGroupPlaceEntity;
import com.biz.crm.sfa.business.sign.in.local.repository.SignInGroupPlaceRepository;
import com.biz.crm.sfa.business.sign.in.local.service.SignInGroupPlaceService;
import com.biz.crm.sfa.business.sign.in.sdk.dto.SignInGroupDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="signInGroupPlaceService")
public class SignInGroupPlaceServiceImpl
implements SignInGroupPlaceService {
    private static final Logger log = LoggerFactory.getLogger(SignInGroupPlaceServiceImpl.class);
    @Autowired
    private SignInGroupPlaceRepository signInGroupPlaceRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void update(SignInGroupDto dto) {
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u7b7e\u5230\u7ec4ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.signInGroupPlaceRepository.deleteByGroupId(dto.getId());
        if (CollectionUtils.isEmpty((Collection)dto.getPlaceList())) {
            return;
        }
        this.updateValidation(dto);
        List entities = dto.getPlaceList().stream().map(placeDto -> {
            SignInGroupPlaceEntity entity = (SignInGroupPlaceEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(placeDto, SignInGroupPlaceEntity.class, HashSet.class, ArrayList.class, new String[0])));
            entity.setGroupId(dto.getId());
            return entity;
        }).collect(Collectors.toList());
        this.signInGroupPlaceRepository.saveBatch(entities);
    }

    private void updateValidation(SignInGroupDto dto) {
        Validate.notBlank((CharSequence)dto.getElectronFenceType(), (String)"\u7f3a\u5931\u6253\u5361\u8303\u56f4\u7c7b\u578b", (Object[])new Object[0]);
        dto.getPlaceList().forEach(placeDto -> {
            int placeNo = dto.getPlaceList().indexOf(placeDto) + 1;
            placeDto.setPlaceNo(String.valueOf(placeNo));
            Validate.notBlank((CharSequence)placeDto.getPlaceName(), (String)String.format("\u5e8f\u53f7%s,\u7f3a\u5931\u5730\u70b9\u540d\u79f0", placeNo), (Object[])new Object[0]);
            Validate.notBlank((CharSequence)placeDto.getPlaceAddress(), (String)String.format("\u5e8f\u53f7%s,\u7f3a\u5931\u5730\u70b9\u5730\u5740", placeNo), (Object[])new Object[0]);
            Validate.isTrue((Objects.nonNull(placeDto.getPlaceRange()) && placeDto.getPlaceRange() > 0 ? 1 : 0) != 0, (String)String.format("\u5e8f\u53f7%s,\u5730\u70b9\u8303\u56f4\u6570\u636e\u9519\u8bef", placeNo), (Object[])new Object[0]);
            Validate.notNull((Object)placeDto.getPlaceLatitude(), (String)String.format("\u5e8f\u53f7%s,\u7f3a\u5931\u5730\u70b9\u7eac\u5ea6", placeNo), (Object[])new Object[0]);
            Validate.notNull((Object)placeDto.getPlaceLongitude(), (String)String.format("\u5e8f\u53f7%s,\u7f3a\u5931\u5730\u70b9\u7ecf\u5ea6", placeNo), (Object[])new Object[0]);
        });
    }
}

