/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.sign.in.local.service.internal;

import com.biz.crm.sfa.business.sign.in.local.entity.SignInGroupTypeEntity;
import com.biz.crm.sfa.business.sign.in.local.repository.SignInGroupTypeRepository;
import com.biz.crm.sfa.business.sign.in.local.service.SignInGroupTypeService;
import com.biz.crm.sfa.business.sign.in.sdk.dto.SignInGroupDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="signInGroupTypeService")
public class SignInGroupTypeServiceImpl
implements SignInGroupTypeService {
    private static final Logger log = LoggerFactory.getLogger(SignInGroupTypeServiceImpl.class);
    @Autowired
    private SignInGroupTypeRepository signInGroupTypeRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void update(SignInGroupDto dto) {
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u7b7e\u5230\u7ec4ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.signInGroupTypeRepository.deleteByGroupId(dto.getId());
        if (CollectionUtils.isEmpty((Collection)dto.getTypeList())) {
            return;
        }
        this.updateValidation(dto);
        List entities = dto.getTypeList().stream().map(typeDto -> {
            SignInGroupTypeEntity entity = (SignInGroupTypeEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(typeDto, SignInGroupTypeEntity.class, HashSet.class, ArrayList.class, new String[0])));
            entity.setGroupId(dto.getId());
            return entity;
        }).collect(Collectors.toList());
        this.signInGroupTypeRepository.saveBatch(entities);
    }

    private void updateValidation(SignInGroupDto dto) {
        dto.getTypeList().forEach(typeDto -> Validate.notBlank((CharSequence)typeDto.getTypeId(), (String)"\u7f3a\u5931\u7b7e\u5230\u7c7b\u578bID", (Object[])new Object[0]));
    }
}

