package com.biz.crm.sfa.business.sign.in.sdk.constant;

import lombok.AccessLevel;
import lombok.NoArgsConstructor;

import java.time.format.DateTimeFormatter;

/**
 * 签到常量
 *
 * @author ning.zhang
 * @date 2022/5/23
 */
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class SignInConstant {

  /**
   * 时间日期格式 yyyy-MM-dd HH:mm:ss
   */
  public static final DateTimeFormatter YYYY_MM_DD_HH_MM_SS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
  /**
   * 时间日期格式 yyyy-MM-dd
   */
  public static final DateTimeFormatter YYYY_MM_DD = DateTimeFormatter.ofPattern("yyyy-MM-dd");
  /**
   * 时间日期格式 HH:mm:ss
   */
  public static final DateTimeFormatter HH_MM_SS = DateTimeFormatter.ofPattern("HH:mm:ss");
  /**
   * 时间日期格式 yyyy-MM
   */
  public static final DateTimeFormatter YYYY_MM = DateTimeFormatter.ofPattern("yyyy-MM");
  /**
   * 时间日期格式 yyyy
   */
  public static final DateTimeFormatter YYYY = DateTimeFormatter.ofPattern("yyyy");

}
