package com.biz.crm.sfa.business.sign.in.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 签到类型Dto
 *
 * @author ning.zhang
 * @date 2022/5/9
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "SignInTypeDto", description = "签到类型Dto")
public class SignInTypeDto extends TenantDto {

  /**
   * 序号
   */
  @ApiModelProperty("序号")
  private Integer lineNo;

  /**
   * 类型名称
   */
  @ApiModelProperty("类型名称")
  private String typeName;

  /**
   * 是否拍照(Y:是,N:否)
   *
   * @see com.biz.crm.business.common.sdk.enums.BooleanEnum
   */
  @ApiModelProperty("是否拍照(Y:是,N:否)")
  private String photograph;

  /**
   * 是否指定时间(Y:是,N:否)
   *
   * @see com.biz.crm.business.common.sdk.enums.BooleanEnum
   */
  @ApiModelProperty("是否指定时间(Y:是,N:否)")
  private String appointTime;

  /**
   * 开始时间
   */
  @ApiModelProperty("打卡开始时间")
  private String beginTime;

  /**
   * 结束时间
   */
  @ApiModelProperty("打卡结束时间")
  private String endTime;
  /**
   * 备注
   */
  @ApiModelProperty(value = "备注")
  private String remark;
}
