package com.biz.crm.sfa.business.sign.in.sdk.event;

import com.biz.crm.sfa.business.sign.in.sdk.vo.SignInGroupVo;

import java.util.List;

/**
 * 签到组事件通知
 *
 * @author ning.zhang
 * @date 2022/5/5
 */
public interface SignInGroupEventListener {

  /**
   * 当签到组新增时触发
   *
   * @param vo 签到组信息
   */
  void onCreate(SignInGroupVo vo);

  /**
   * 当签到组修改时触发
   *
   * @param oldVo 修改之前的vo
   * @param newVo 修改之后的vo
   */
  void onUpdate(SignInGroupVo oldVo, SignInGroupVo newVo);

  /**
   * 当签到组禁用时触发
   *
   * @param voList 禁用vo信息
   */
  void onDisable(List<SignInGroupVo> voList);

  /**
   * 当签到组启用时触发
   *
   * @param voList 禁用vo信息
   */
  void onEnable(List<SignInGroupVo> voList);

  /**
   * 当签到组删除时触发
   *
   * @param voList 删除vo信息
   */
  void onDelete(List<SignInGroupVo> voList);
}
