package com.biz.crm.sfa.business.sign.in.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.sign.in.sdk.dto.SignInGroupUserPageDto;
import com.biz.crm.sfa.business.sign.in.sdk.vo.SignInGroupVo;
import org.springframework.data.domain.Pageable;

/**
 * 签到组Vo服务接口
 *
 * @author ning.zhang
 * @date 2022/5/10
 */
public interface SignInGroupVoService {

  /**
   * 通过签到组ID获取签到组信息
   *
   * @param id 签到组ID
   * @return 签到组信息
   */
  SignInGroupVo findById(String id);

  /**
   * 移动端-当前用户签到组分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<SignInGroupVo> 签到组分页信息
   */
  Page<SignInGroupVo> findBySignInGroupUserPageDto(Pageable pageable, SignInGroupUserPageDto dto);
}
