package com.biz.crm.sfa.business.sign.in.sdk.vo;

import com.biz.crm.business.common.sdk.vo.UuidOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * 签到组日期Vo
 *
 * @author ning.zhang
 * @date 2022/5/9
 */
@Getter
@Setter
@ApiModel(value = "SignInGroupDateVo", description = "签到组日期Vo")
public class SignInGroupDateVo extends UuidOpVo {

  private static final long serialVersionUID = -8278423433134507766L;

  /**
   * 时间段序号
   */
  @ApiModelProperty("时间段序号")
  private String timeNo;

  /**
   * 开始日期
   */
  @ApiModelProperty("开始日期")
  private String startTime;

  /**
   * 结束日期
   */
  @ApiModelProperty("结束日期")
  private String endTime;
}
