package com.biz.crm.sfa.business.sign.in.sdk.vo;

import com.biz.crm.business.common.sdk.vo.UuidOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * 签到组地点Vo
 *
 * @author ning.zhang
 * @date 2022/5/9
 */
@Getter
@Setter
@ApiModel(value = "SignInGroupPlaceVo", description = "签到组地点Vo")
public class SignInGroupPlaceVo extends UuidOpVo {

  private static final long serialVersionUID = 8030469678019096915L;

  /**
   * 地点序号
   */
  @ApiModelProperty("地点序号")
  private String placeNo;

  /**
   * 地点名称
   */
  @ApiModelProperty("地点名称")
  private String placeName;

  /**
   * 地点地址
   */
  @ApiModelProperty("地点地址")
  private String placeAddress;

  /**
   * 地点经度
   */
  @ApiModelProperty("地点经度")
  private BigDecimal placeLongitude;

  /**
   * 地点纬度
   */
  @ApiModelProperty("地点纬度")
  private BigDecimal placeLatitude;

  /**
   * 地点范围(单位米)
   */
  @ApiModelProperty("地点范围(单位米)")
  private Integer placeRange;
}
