package com.biz.crm.sfa.business.sign.in.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 签到组Vo
 *
 * @author ning.zhang
 * @date 2022/5/9
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "SignInGroupVo", description = "签到组Vo")
public class SignInGroupVo extends TenantFlagOpVo {

  private static final long serialVersionUID = -5264304437404677124L;

  /**
   * 签到组编码
   */
  @ApiModelProperty("签到组编码")
  private String groupCode;

  /**
   * 签到组名称
   */
  @ApiModelProperty("签到组名称")
  private String groupName;

  /**
   * 有效时间类型(long_time:长期有效;diy_time:自定义有效期)
   *
   * @see com.biz.crm.sfa.business.sign.in.sdk.enums.SignInTimeType
   */
  @ApiModelProperty("有效时间类型(long_time:长期有效;diy_time:自定义有效期)")
  private String timeType;

  /**
   * 打卡范围类型(none:无打卡范围;out_sign_ex:允许范围外打卡，地点记录为异常;out_sign_ok:允许范围外打卡，地点记录为正常;no_out_sign:不允许范围外打卡)
   *
   * @see com.biz.crm.sfa.business.sign.in.sdk.enums.SignInElectronFenceType
   */
  @ApiModelProperty("打卡范围类型(none:无打卡范围;out_sign_ex:允许范围外打卡，地点记录为异常;out_sign_ok:允许范围外打卡，地点记录为正常;no_out_sign:不允许范围外打卡)")
  private String electronFenceType;

  /**
   * 打卡日期信息
   */
  @ApiModelProperty("打卡日期信息")
  private List<SignInGroupDateVo> dateList;

  /**
   * 打卡地点信息
   */
  @ApiModelProperty("打卡地点信息")
  private List<SignInGroupPlaceVo> placeList;

  /**
   * 打卡范围信息
   */
  @ApiModelProperty("打卡范围信息")
  private List<SignInGroupScopeVo> scopeList;

  /**
   * 签到类型信息
   */
  @ApiModelProperty("签到类型信息")
  private List<SignInGroupTypeVo> typeList;
}
