package com.biz.crm.sfa.business.sign.in.sdk.vo;

import com.biz.crm.business.common.sdk.vo.UuidOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 签到照片Vo
 *
 * @author ning.zhang
 * @date 2022/5/24
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "SignInPictureVo", description = "签到照片Vo")
public class SignInPictureVo extends UuidOpVo {


  private static final long serialVersionUID = -7595780998589722201L;

  /**
   * 照片路径(物理路径)
   */
  @ApiModelProperty("照片路径(物理路径)")
  private String picPath;

  /**
   * 照片地址
   */
  @ApiModelProperty("照片地址")
  private String picUrl;

  /**
   * 照片描述
   */
  @ApiModelProperty("照片描述")
  private String picDesc;
}
