package com.biz.crm.sfa.business.sign.in.sdk.vo;

import com.biz.crm.business.common.sdk.vo.FileVo;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 签到记录Vo
 *
 * @author ning.zhang
 * @date 2022/5/27
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "SignInRecordVo", description = "签到记录Vo")
public class SignInRecordVo extends TenantFlagOpVo {

  private static final long serialVersionUID = -458654634131859289L;

  /**
   * 签到组ID
   */
  @ApiModelProperty("签到组ID")
  private String groupId;

  /**
   * 签到组名称
   */
  @ApiModelProperty("签到组名称")
  private String groupName;

  /**
   * 签到类型ID
   */
  @ApiModelProperty("签到类型ID")
  private String signInTypeId;

  /**
   * 签到类型名称
   */
  @ApiModelProperty("签到类型名称")
  private String signInTypeName;

  /**
   * 签到人员帐号
   */
  @ApiModelProperty("签到人员帐号")
  private String userName;

  /**
   * 人员名称
   */
  @ApiModelProperty("人员名称")
  private String userRealName;

  /**
   * 签到时间(HH:mm:ss)
   */
  @ApiModelProperty("签到时间(HH:mm:ss)")
  private String signInTime;

  /**
   * 签到日期(YYYY-MM-DD)
   */
  @ApiModelProperty("签到日期(YYYY-MM-DD)")
  private String signInDate;

  /**
   * 签到经度
   */
  @ApiModelProperty("签到经度")
  private BigDecimal signInLongitude;

  /**
   * 签到纬度
   */
  @ApiModelProperty("签到纬度")
  private BigDecimal signInLatitude;

  /**
   * 签到地点
   */
  @ApiModelProperty("签到地点")
  private String signInPlace;

  /**
   * 签到地点状态(ok:正常;ex:异常)
   *
   * @see com.biz.crm.sfa.business.sign.in.sdk.enums.SignInPlaceStatus
   */
  @ApiModelProperty("签到地点状态(ok:正常;ex:异常)")
  private String signInPlaceStatus;

  /**
   * 签到状态(ok:正常;error:异常;none:未打卡)
   *
   * @see com.biz.crm.sfa.business.sign.in.sdk.enums.SignInStatus
   */
  @ApiModelProperty("签到状态(ok:正常;error:异常;none:未打卡)")
  private String signInStatus;

  /**
   * 签到图片集合
   */
  @ApiModelProperty(value = "签到图片集合")
  private List<FileVo> pictureList;
}
