package com.biz.crm.sfa.business.sign.in.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Set;

/**
 * 签到组分页Dto
 *
 * @author ning.zhang
 * @date 2022/5/5
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "SignInGroupPageDto", description = "签到组分页Dto")
public class SignInGroupPageDto extends TenantDto {

  /**
   * 签到组名称
   */
  @ApiModelProperty("签到组名称")
  private String groupName;

  /**
   * 签到组编码
   */
  @ApiModelProperty("签到组编码")
  private String groupCode;

  /**
   * 用户账号
   */
  @ApiModelProperty("用户账号")
  private String userName;

  /**
   * 组织编码集合
   */
  @ApiModelProperty("组织编码集合")
  private Set<String> orgCodes;

  /***
   * 启禁用状态
   *
   * @see com.biz.crm.business.common.sdk.enums.EnableStatusEnum
   */
  @ApiModelProperty("启禁用状态")
  private String enableStatus;

  /**
   * 签到日期(YYYY-MM-DD)
   */
  @ApiModelProperty("签到日期(YYYY-MM-DD)")
  private String signInDate;
}
