package com.biz.crm.sfa.business.sign.in.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * 签到组范围Dto
 *
 * @author ning.zhang
 * @date 2022/5/9
 */
@Getter
@Setter
@ApiModel(value = "SignInGroupScopeDto", description = "签到组范围Dto")
public class SignInGroupScopeDto {

  /**
   * 范围编码
   */
  @ApiModelProperty("范围编码")
  private String scopeCode;

  /**
   * 范围类型(org:组织;user:人员)
   *
   * @see com.biz.crm.sfa.business.sign.in.sdk.enums.SignInScopeType
   */
  @ApiModelProperty("范围类型(org:组织;user:人员)")
  private String scopeType;

}
