package com.biz.crm.sfa.business.sign.in.sdk.dto;

import com.biz.crm.business.common.sdk.dto.FileDto;
import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 签到记录Dto
 *
 * @author ning.zhang
 * @date 2022/5/23
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "SignInRecordDto", description = "签到记录Dto")
public class SignInRecordDto extends TenantDto {

  /**
   * 签到组ID
   */
  @ApiModelProperty(value = "签到组ID")
  private String groupId;

  /**
   * 打卡类型ID
   */
  @ApiModelProperty(value = "打卡类型ID")
  private String signInTypeId;

  /**
   * 签到经度
   */
  @ApiModelProperty(value = "签到经度")
  private BigDecimal signInLongitude;

  /**
   * 签到纬度
   */
  @ApiModelProperty(value = "签到纬度")
  private BigDecimal signInLatitude;

  /**
   * 签到地点
   */
  @ApiModelProperty(value = "签到地点")
  private String signInPlace;

  /**
   * 备注
   */
  @ApiModelProperty(value = "备注")
  private String remark;

  /**
   * 签到图片集合
   */
  @ApiModelProperty(value = "签到图片集合")
  private List<FileDto> pictureList;

  /***
   * 签到人员帐号
   */
  @ApiModelProperty(value = "签到人员帐号", hidden = true)
  private String userName;

  /**
   * 签到时间(HH:mm:ss)
   */
  @ApiModelProperty(value = "签到时间(HH:mm:ss)", hidden = true)
  private String signInTime;

  /**
   * 签到日期(YYYY-MM-DD)
   */
  @ApiModelProperty(value = "签到日期(YYYY-MM-DD)", hidden = true)
  private String signInDate;

  /**
   * 签到地点状态(ok:正常;ex:异常)
   *
   * @see com.biz.crm.sfa.business.sign.in.sdk.enums.SignInPlaceStatus
   */
  @ApiModelProperty(value = "签到地点状态(ok:正常;ex:异常)", hidden = true)
  private String signInPlaceStatus;
}
