package com.biz.crm.sfa.business.sign.in.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 签到打卡范围枚举类
 *
 * @author ning.zhang
 * @date 2022/4/29
 */
@Getter
@AllArgsConstructor
public enum SignInElectronFenceType {

  /**
   * 无打卡范围
   */
  NONE("none", "none", "无打卡范围", "1"),
  /**
   * 允许范围外打卡，地点记录为异常
   */
  OUT_SIGN_EX("out_sign_ex", "out_sign_ex", "允许范围外打卡，地点记录为异常", "2"),
  /**
   * 允许范围外打卡，地点记录为正常
   */
  OUT_SIGN_OK("out_sign_ok", "out_sign_ok", "允许范围外打卡，地点记录为正常", "3"),
  /**
   * 自由时间上下班规则
   */
  NO_OUT_SIGN("no_out_sign", "no_out_sign", "不允许范围外打卡", "4"),;

  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;
}
