package com.biz.crm.sfa.business.sign.in.sdk.vo;

import com.biz.crm.business.common.sdk.vo.UuidOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * 签到组范围Vo
 *
 * @author ning.zhang
 * @date 2022/5/9
 */
@Getter
@Setter
@ApiModel(value = "SignInGroupScopeVo", description = "签到组范围Vo")
public class SignInGroupScopeVo extends UuidOpVo {

  private static final long serialVersionUID = 322452235794597155L;

  /**
   * 范围编码
   */
  @ApiModelProperty("范围编码")
  private String scopeCode;

  /**
   * 范围名称
   */
  @ApiModelProperty("范围名称")
  private String scopeName;

  /**
   * 范围类型(org:组织;user:人员)
   *
   * @see com.biz.crm.sfa.business.sign.in.sdk.enums.SignInScopeType
   */
  @ApiModelProperty("范围类型(org:组织;user:人员)")
  private String scopeType;

}
