package com.biz.crm.sfa.business.sign.in.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 签到类型Vo
 *
 * @author ning.zhang
 * @date 2022/5/9
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "AttendanceRuleVo", description = "签到类型Vo")
public class SignInTypeVo extends TenantFlagOpVo {

  private static final long serialVersionUID = 4953557029358475310L;

  /**
   * 序号
   */
  @ApiModelProperty("序号")
  private Integer lineNo;

  /**
   * 类型名称
   */
  @ApiModelProperty("类型名称")
  private String typeName;

  /**
   * 是否拍照(Y:是,N:否)
   *
   * @see com.biz.crm.business.common.sdk.enums.BooleanEnum
   */
  @ApiModelProperty("是否拍照(Y:是,N:否)")
  private String photograph;

  /**
   * 是否指定时间(Y:是,N:否)
   *
   * @see com.biz.crm.business.common.sdk.enums.BooleanEnum
   */
  @ApiModelProperty("是否指定时间(Y:是,N:否)")
  private String appointTime;

  /**
   * 开始时间
   */
  @ApiModelProperty("开始时间")
  private String beginTime;

  /**
   * 结束时间
   */
  @ApiModelProperty("结束时间")
  private String endTime;
}
