/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.sms.local.service.internal;

import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.common.sms.sdk.service.ValiditySmsCodeService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ValiditySmsCodeServiceImpl
implements ValiditySmsCodeService {
    @Autowired(required=false)
    private RedisService redisService;

    @Deprecated
    public void setVerificationCodeValidityPeriod(String phone, String verificationCode) {
        this.setVerificationCodeValidityPeriod(null, phone, verificationCode, 300L);
    }

    public void setVerificationCodeValidityPeriod(String templateId, String phone, String verificationCode) {
        this.setVerificationCodeValidityPeriod(templateId, phone, verificationCode, 300L);
    }

    @Deprecated
    public void setVerificationCodeValidityPeriod(String phone, String verificationCode, long timeout) {
        this.setVerificationCodeValidityPeriod(null, phone, verificationCode, 300L);
    }

    public void setVerificationCodeValidityPeriod(String templateId, String phone, String verificationCode, long timeout) {
        this.setVerificationCodeValidityPeriod(templateId, phone, verificationCode, timeout, 1, 1);
    }

    public void setVerificationCodeValidityPeriod(String templateId, String phone, String verificationCode, long timeout, int minutes, int times) {
        Validate.notNull((Object)phone, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)templateId)) {
            templateId = "unknown";
        }
        if (timeout <= 0L) {
            timeout = 300L;
        }
        String redisKey = StringUtils.join((Object[])new String[]{"sms_verification_code_times:", templateId, ":", phone});
        Long incrTimes = this.redisService.incr(redisKey, 1L);
        this.redisService.expire(redisKey, (long)minutes * 60L);
        Validate.isTrue((incrTimes <= (long)times ? 1 : 0) != 0, (String)String.format("\u7531\u4e8e\u60a8\u64cd\u4f5c\u9891\u7e41\uff0c\u8bf7%d\u5206\u949f\u540e\u91cd\u65b0\u5c1d\u8bd5", minutes), (Object[])new Object[0]);
        Validate.notNull((Object)verificationCode, (String)"\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.redisService.hSet(StringUtils.join((Object[])new String[]{"sms_verification_code:", phone, ":", verificationCode}), StringUtils.join((Object[])new String[]{phone, verificationCode}), (Object)verificationCode, timeout);
    }

    public Boolean isAvailableVerificationCode(String phone, String verificationCode) {
        Validate.notNull((Object)phone, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)verificationCode, (String)"\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Object obj = this.redisService.hGet(StringUtils.join((Object[])new String[]{"sms_verification_code:", phone, ":", verificationCode}), StringUtils.join((Object[])new String[]{phone, verificationCode}));
        if (obj != null) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

