package com.biz.crm.common.sms.local.config;

import lombok.Getter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;

/**
 * @author ning.zhang
 * @description 阿里云短信配置
 * @date 2024/8/16
*/
@Configuration
@Getter
@ConditionalOnProperty(prefix = "sms", name = "supplier", havingValue = "mos")
public class MosSmsConfiguration {


  @Value("${sms.url:}")
  private String url;

  @Value("${sms.accessKeyId:}")
  private String accessKeyId;

  @Value("${sms.accessKeySecret:}")
  private String accessKeySecret;

  @Value("${sms.signName:}")
  private String signName;
}
