package com.biz.crm.common.sms.local.service.internal;

import com.aliyun.dysmsapi20170525.Client;
import com.aliyun.dysmsapi20170525.models.SendSmsRequest;
import com.aliyun.dysmsapi20170525.models.SendSmsResponse;
import com.aliyun.teaopenapi.models.Config;
import com.biz.crm.common.sms.local.config.AliyunSmsConfiguration;
import com.bizunited.nebula.common.service.sms.SmsServiceAdapter;
import com.bizunited.nebula.common.service.sms.SmsTypeEnums;
import javax.annotation.PostConstruct;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

/**
 * 阿里云短信发送实现类
 *
 * @author pengxi
 * @date 2022-05-07
 */
@Slf4j
@Service
@ConditionalOnProperty(prefix = "sms", name = "supplier", havingValue = "aliyun")
public class AliyunSmsServiceImpl extends SmsServiceAdapter {

  private Client client;

  @Autowired
  private AliyunSmsConfiguration aliyunSmsConfiguration;

  @PostConstruct
  public void initClient() throws Exception {
    Config config = new Config()
        // 您的AccessKey ID
        .setAccessKeyId(aliyunSmsConfiguration.getAccessKeyId())
        // 您的AccessKey Secret
        .setAccessKeySecret(aliyunSmsConfiguration.getAccessKeySecret())
        // 访问的域名
        .setEndpoint(aliyunSmsConfiguration.getEndpoint());
    this.client = new Client(config);
  }


  public void aliyunSendSms(SendSmsRequest sendSmsRequest) {
    try {
      SendSmsResponse resp = this.client.sendSms(sendSmsRequest);
      String success = "OK";
      Validate.isTrue(StringUtils.equals(resp.body.code, success), resp.body.message);
    } catch (Exception e) {
      log.error("短信发送异常：{}",e.getMessage(),e);
      Validate.isTrue(Boolean.FALSE, "短信发送异常：" + e.getMessage());
    }
  }


  @Override
  public void sendSms(String phone, String templateId, String content, SmsTypeEnums smsType) {

    Validate.notNull(phone, "手机号不能为空！");
    Validate.notNull(content, "短信内容不能为空！");
    Validate.notNull(smsType, "短信类型不能为空！");

    SendSmsRequest sendSmsRequest = new SendSmsRequest();
    sendSmsRequest.setSignName(aliyunSmsConfiguration.getSignName());
    sendSmsRequest.setPhoneNumbers(phone);
    sendSmsRequest.setTemplateCode(templateId);
    //sendSmsRequest.setTemplateParam("{\"code\":\"" + verificationCode + "\"}");
    sendSmsRequest.setTemplateParam(content);
    this.aliyunSendSms(sendSmsRequest);
  }
}